/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.sf.cglib.beans.BulkBean;
import net.sf.cglib.reflect.FastClass;
import net.sf.cglib.transform.impl.InterceptFieldCallback;
import net.sf.cglib.transform.impl.InterceptFieldEnabled;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.InstantiationException;
import org.hibernate.MappingException;
import org.hibernate.PropertyAccessException;
import org.hibernate.PropertyNotFoundException;
import org.hibernate.cache.CacheConcurrencyStrategy;
import org.hibernate.cache.CacheKey;
import org.hibernate.cfg.Environment;
import org.hibernate.engine.CacheEntryStructure;
import org.hibernate.engine.Cascades;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.StructuredCacheEntry;
import org.hibernate.engine.UnstructuredCacheEntry;
import org.hibernate.engine.Versioning;
import org.hibernate.id.Assigned;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.PostInsertIdentifierGenerator;
import org.hibernate.intercept.FieldInterceptor;
import org.hibernate.intercept.LazyPropertyInitializer;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Subclass;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.persister.EntityPersister;
import org.hibernate.persister.OuterJoinLoadable;
import org.hibernate.persister.Queryable;
import org.hibernate.persister.SQLLoadable;
import org.hibernate.persister.UniqueKeyLoadable;
import org.hibernate.property.Getter;
import org.hibernate.property.Setter;
import org.hibernate.proxy.CGLIBProxyFactory;
import org.hibernate.proxy.MapProxyFactory;
import org.hibernate.proxy.ProxyFactory;
import org.hibernate.type.AbstractComponentType;
import org.hibernate.type.IdentifierType;
import org.hibernate.type.PrimitiveType;
import org.hibernate.type.Type;
import org.hibernate.type.TypeFactory;
import org.hibernate.type.VersionType;
import org.hibernate.util.ReflectHelper;
import org.hibernate.util.StringHelper;

public abstract class AbstractEntityPersister
implements OuterJoinLoadable,
Queryable,
ClassMetadata,
UniqueKeyLoadable,
SQLLoadable,
LazyPropertyInitializer {
    private static final Log log = LogFactory.getLog((Class)(class$org$hibernate$persister$AbstractEntityPersister == null ? (class$org$hibernate$persister$AbstractEntityPersister = AbstractEntityPersister.class$("org.hibernate.persister.AbstractEntityPersister")) : class$org$hibernate$persister$AbstractEntityPersister));
    public static final String ENTITY_CLASS = "class";
    private final SessionFactoryImplementor factory;
    private final Class mappedClass;
    private final boolean isDynamic;
    private final boolean polymorphic;
    private final boolean explicitPolymorphism;
    private final boolean inherited;
    private final boolean hasSubclasses;
    private final boolean versioned;
    private final boolean abstractClass;
    private final boolean implementsLifecycle;
    private final boolean implementsValidatable;
    private final boolean hasCollections;
    private final boolean hasLazyProperties;
    private final boolean hasCascades;
    private final boolean mutable;
    private final boolean selectBeforeUpdate;
    private final String superclass;
    private final boolean dynamicUpdate;
    private final boolean dynamicInsert;
    private final int optimisticLockMode;
    private final String entityName;
    private final Type entityType;
    private final Constructor constructor;
    private final BulkBean optimizer;
    private final FastClass fastClass;
    private final String rootEntityName;
    private final CacheEntryStructure cacheEntryStructure;
    private final Class concreteProxyClass;
    private final boolean isLazy;
    private final ProxyFactory proxyFactory;
    private final boolean isIdentifierAssignedByInsert;
    private final boolean hasEmbeddedIdentifier;
    private final String identifierPropertyName;
    private final Cascades.IdentifierValue unsavedIdentifierValue;
    private final Type identifierType;
    private final Setter identifierSetter;
    private final Getter identifierGetter;
    private final IdentifierGenerator identifierGenerator;
    private final VersionType versionType;
    private final Getter versionGetter;
    private final int versionProperty;
    private final Cascades.VersionValue unsavedVersionValue;
    private final int propertySpan;
    private final String[] propertyNames;
    private final Type[] propertyTypes;
    private final boolean[] propertyLaziness;
    private final boolean[] propertyUpdateability;
    private final boolean[] propertyCheckability;
    private final boolean[] propertyInsertability;
    private final boolean[] propertyNullability;
    private final boolean[] propertyVersionability;
    private final Getter[] getters;
    private final Setter[] setters;
    private final Cascades.CascadeStyle[] cascadeStyles;
    private final Map gettersByPropertyName = new HashMap();
    private final Map settersByPropertyName = new HashMap();
    private final Map typesByPropertyName = new HashMap();
    private final Map entityNameBySubclass = new HashMap();
    private final CacheConcurrencyStrategy cache;
    static /* synthetic */ Class class$org$hibernate$persister$AbstractEntityPersister;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$org$hibernate$classic$Lifecycle;
    static /* synthetic */ Class class$org$hibernate$classic$Validatable;
    static /* synthetic */ Class class$org$hibernate$proxy$HibernateProxy;
    static /* synthetic */ Class class$net$sf$cglib$transform$impl$InterceptFieldEnabled;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected AbstractEntityPersister(PersistentClass persistentClass, CacheConcurrencyStrategy cache, SessionFactoryImplementor factory) throws HibernateException {
        Constructor con;
        this.factory = factory;
        this.cache = cache;
        this.cacheEntryStructure = factory.getSettings().isStructuredCacheEntriesEnabled() ? new StructuredCacheEntry(this) : new UnstructuredCacheEntry();
        this.entityName = persistentClass.getEntityName();
        this.isDynamic = persistentClass.isDynamic();
        Class clazz = this.isDynamic ? (class$java$util$Map == null ? (class$java$util$Map = AbstractEntityPersister.class$("java.util.Map")) : class$java$util$Map) : persistentClass.getMappedClass();
        this.mappedClass = clazz;
        this.rootEntityName = persistentClass.getRootClass().getEntityName();
        this.mutable = persistentClass.isMutable();
        this.selectBeforeUpdate = persistentClass.hasSelectBeforeUpdate();
        this.dynamicUpdate = persistentClass.useDynamicUpdate();
        this.dynamicInsert = persistentClass.useDynamicInsert();
        this.polymorphic = persistentClass.isPolymorphic();
        this.explicitPolymorphism = persistentClass.isExplicitPolymorphism() || this.isDynamic;
        this.inherited = persistentClass.isInherited();
        this.superclass = this.inherited ? persistentClass.getSuperclass().getEntityName() : null;
        this.hasSubclasses = persistentClass.hasSubclasses();
        boolean bl = this.abstractClass = !this.isDynamic && ReflectHelper.isAbstractClass(this.mappedClass);
        if (!this.isDynamic) {
            try {
                con = ReflectHelper.getDefaultConstructor(this.mappedClass);
            }
            catch (PropertyNotFoundException pnfe) {
                log.info((Object)("no default (no-argument) constructor for class: " + this.mappedClass.getName() + " (class must be instantiated by Interceptor)"));
                con = null;
            }
        } else {
            con = null;
        }
        this.constructor = con;
        this.entityType = TypeFactory.manyToOne(this.entityName);
        this.optimisticLockMode = persistentClass.getOptimisticLockMode();
        if (this.optimisticLockMode > 0 && !this.dynamicUpdate) {
            throw new MappingException("optimistic-lock setting requires dynamic-update=\"true\": " + this.entityName);
        }
        this.hasEmbeddedIdentifier = persistentClass.hasEmbeddedIdentifier();
        KeyValue idValue = persistentClass.getIdentifier();
        this.identifierType = idValue.getType();
        if (persistentClass.hasIdentifierProperty()) {
            Property idProperty = persistentClass.getIdentifierProperty();
            this.identifierPropertyName = idProperty.getName();
            this.identifierSetter = idProperty.getSetter(this.mappedClass);
            this.identifierGetter = idProperty.getGetter(this.mappedClass);
        } else {
            this.identifierPropertyName = null;
            this.identifierGetter = null;
            this.identifierSetter = null;
        }
        Class proxyInterfaceClass = persistentClass.getProxyInterface();
        Method proxyGetIdentifierMethod = null;
        Method proxySetIdentifierMethod = null;
        if (persistentClass.hasIdentifierProperty() && proxyInterfaceClass != null) {
            Property idProperty = persistentClass.getIdentifierProperty();
            try {
                proxyGetIdentifierMethod = idProperty.getGetter(proxyInterfaceClass).getMethod();
            }
            catch (PropertyNotFoundException pnfe) {
                // empty catch block
            }
            try {
                proxySetIdentifierMethod = idProperty.getSetter(proxyInterfaceClass).getMethod();
            }
            catch (PropertyNotFoundException pnfe) {
                // empty catch block
            }
        }
        this.propertySpan = persistentClass.getPropertyClosureSpan();
        this.identifierGenerator = factory.getIdentifierGenerator(persistentClass.getRootClass().getEntityName());
        this.isIdentifierAssignedByInsert = this.identifierGenerator instanceof PostInsertIdentifierGenerator;
        String unsavedValue = persistentClass.getIdentifier().getNullValue();
        if (unsavedValue == null) {
            if (this.identifierGetter != null && this.identifierGetter.getReturnType().isPrimitive()) {
                Serializable defaultValue = ((PrimitiveType)this.identifierType).getDefaultValue();
                this.unsavedIdentifierValue = new Cascades.IdentifierValue(defaultValue);
            } else {
                this.unsavedIdentifierValue = Cascades.SAVE_NULL;
            }
        } else if ("null".equals(unsavedValue)) {
            this.unsavedIdentifierValue = Cascades.SAVE_NULL;
        } else if ("undefined".equals(unsavedValue)) {
            this.unsavedIdentifierValue = Cascades.UNDEFINED;
        } else if ("none".equals(unsavedValue)) {
            this.unsavedIdentifierValue = Cascades.SAVE_NONE;
        } else if ("any".equals(unsavedValue)) {
            this.unsavedIdentifierValue = Cascades.SAVE_ANY;
        } else {
            Type idType = persistentClass.getIdentifier().getType();
            try {
                this.unsavedIdentifierValue = new Cascades.IdentifierValue((Serializable)((IdentifierType)idType).stringToObject(unsavedValue));
            }
            catch (ClassCastException cce) {
                throw new MappingException("Bad identifier type: " + idType.getClass().getName());
            }
            catch (Exception e) {
                throw new MappingException("Could not parse identifier unsaved-value: " + unsavedValue);
            }
        }
        if (persistentClass.isVersioned()) {
            this.versioned = true;
            this.versionGetter = persistentClass.getVersion().getGetter(this.mappedClass);
            this.versionType = (VersionType)persistentClass.getVersion().getType();
        } else {
            this.versioned = false;
            this.versionType = null;
            this.versionGetter = null;
        }
        String versionUnsavedValue = null;
        if (persistentClass.isVersioned()) {
            versionUnsavedValue = ((KeyValue)persistentClass.getVersion().getValue()).getNullValue();
            if (versionUnsavedValue == null || "undefined".equals(versionUnsavedValue)) {
                this.unsavedVersionValue = Cascades.VERSION_UNDEFINED;
            } else if ("null".equals(versionUnsavedValue)) {
                this.unsavedVersionValue = Cascades.VERSION_SAVE_NULL;
            } else {
                if (!"negative".equals(versionUnsavedValue)) throw new MappingException("Could not parse version unsaved-value: " + versionUnsavedValue);
                this.unsavedVersionValue = Cascades.VERSION_NEGATIVE;
            }
        } else {
            this.unsavedVersionValue = null;
        }
        boolean lazyAvailable = this.isLazyAvailable();
        boolean hasLazy = false;
        this.propertyTypes = new Type[this.propertySpan];
        this.propertyNames = new String[this.propertySpan];
        this.propertyUpdateability = new boolean[this.propertySpan];
        this.propertyInsertability = new boolean[this.propertySpan];
        this.propertyCheckability = new boolean[this.propertySpan];
        this.propertyNullability = new boolean[this.propertySpan];
        this.propertyVersionability = new boolean[this.propertySpan];
        this.propertyLaziness = new boolean[this.propertySpan];
        this.getters = new Getter[this.propertySpan];
        this.setters = new Setter[this.propertySpan];
        this.cascadeStyles = new Cascades.CascadeStyle[this.propertySpan];
        String[] setterNames = new String[this.propertySpan];
        String[] getterNames = new String[this.propertySpan];
        Class[] types = new Class[this.propertySpan];
        Iterator iter = persistentClass.getPropertyClosureIterator();
        int i = 0;
        int tempVersionProperty = -66;
        boolean foundCascade = false;
        boolean foundCustomAccessor = false;
        while (iter.hasNext()) {
            boolean lazy;
            Property prop = (Property)iter.next();
            if (prop == persistentClass.getVersion()) {
                tempVersionProperty = i;
            }
            this.propertyNames[i] = prop.getName();
            if (!prop.isBasicPropertyAccessor()) {
                foundCustomAccessor = true;
            }
            this.getters[i] = prop.getGetter(this.mappedClass);
            this.setters[i] = prop.getSetter(this.mappedClass);
            getterNames[i] = this.getters[i].getMethodName();
            setterNames[i] = this.setters[i].getMethodName();
            types[i] = this.getters[i].getReturnType();
            this.propertyTypes[i] = prop.getType();
            this.propertyNullability[i] = prop.isOptional();
            this.propertyUpdateability[i] = prop.isUpdateable();
            this.propertyInsertability[i] = prop.isInsertable();
            this.propertyVersionability[i] = prop.isOptimisticLocked();
            this.propertyLaziness[i] = lazy = prop.isLazy() && lazyAvailable;
            boolean bl2 = this.propertyCheckability[i] = prop.isUpdateable() && !lazy;
            if (lazy) {
                hasLazy = true;
            }
            this.gettersByPropertyName.put(this.propertyNames[i], this.getters[i]);
            this.settersByPropertyName.put(this.propertyNames[i], this.setters[i]);
            this.typesByPropertyName.put(this.propertyNames[i], this.propertyTypes[i]);
            this.cascadeStyles[i] = prop.getCascadeStyle();
            if (this.cascadeStyles[i] != Cascades.STYLE_NONE) {
                foundCascade = true;
            }
            ++i;
        }
        if (this.isDynamic || foundCustomAccessor || !Environment.useReflectionOptimizer()) {
            this.optimizer = null;
            this.fastClass = null;
        } else {
            this.fastClass = ReflectHelper.getFastClass(this.mappedClass);
            this.optimizer = ReflectHelper.getBulkBean(this.mappedClass, getterNames, setterNames, types, this.fastClass);
        }
        this.hasCascades = foundCascade;
        this.versionProperty = tempVersionProperty;
        boolean bl3 = !this.isDynamic && (class$org$hibernate$classic$Lifecycle == null ? (class$org$hibernate$classic$Lifecycle = AbstractEntityPersister.class$("org.hibernate.classic.Lifecycle")) : class$org$hibernate$classic$Lifecycle).isAssignableFrom(this.mappedClass) ? true : (this.implementsLifecycle = false);
        this.implementsValidatable = !this.isDynamic && (class$org$hibernate$classic$Validatable == null ? (class$org$hibernate$classic$Validatable = AbstractEntityPersister.class$("org.hibernate.classic.Validatable")) : class$org$hibernate$classic$Validatable).isAssignableFrom(this.mappedClass);
        this.hasCollections = this.initHasCollections();
        this.hasLazyProperties = hasLazy;
        if (persistentClass.isLazy()) {
            HashSet<Class> proxyInterfaces = new HashSet<Class>();
            if (this.isDynamic) {
                this.concreteProxyClass = class$java$util$Map == null ? (class$java$util$Map = AbstractEntityPersister.class$("java.util.Map")) : class$java$util$Map;
            } else {
                this.concreteProxyClass = persistentClass.getProxyInterface();
                proxyInterfaces.add(class$org$hibernate$proxy$HibernateProxy == null ? (class$org$hibernate$proxy$HibernateProxy = AbstractEntityPersister.class$("org.hibernate.proxy.HibernateProxy")) : class$org$hibernate$proxy$HibernateProxy);
                if (!this.mappedClass.equals(this.concreteProxyClass)) {
                    if (!this.concreteProxyClass.isInterface()) {
                        throw new MappingException("proxy must be either an interface, or the class itself: " + this.entityName);
                    }
                    proxyInterfaces.add(this.concreteProxyClass);
                }
                if (this.mappedClass.isInterface()) {
                    proxyInterfaces.add(this.mappedClass);
                }
                iter = persistentClass.getSubclassIterator();
                while (iter.hasNext()) {
                    Subclass subclass = (Subclass)iter.next();
                    if (subclass.getEntityName().equals(subclass.getProxyInterfaceName())) continue;
                    Class subclassProxy = subclass.getProxyInterface();
                    if (subclassProxy == null) {
                        throw new MappingException("All subclasses must also have proxies: " + this.entityName);
                    }
                    proxyInterfaces.add(subclassProxy);
                }
            }
            ProxyFactory pf = this.createProxyFactory();
            try {
                pf.postInstantiate(this.entityName, this.mappedClass, proxyInterfaces, proxyGetIdentifierMethod, proxySetIdentifierMethod);
            }
            catch (HibernateException he) {
                log.warn((Object)("could not create proxy class for:" + this.entityName), (Throwable)he);
                pf = null;
            }
            this.proxyFactory = pf;
        } else {
            this.proxyFactory = null;
            this.concreteProxyClass = null;
        }
        this.isLazy = this.proxyFactory != null;
        iter = persistentClass.getSubclassIterator();
        while (iter.hasNext()) {
            PersistentClass pc = (PersistentClass)iter.next();
            this.entityNameBySubclass.put(pc.getMappedClass(), pc.getEntityName());
        }
    }

    public final String getEntityName() {
        return this.entityName;
    }

    public final Class getMappedClass() {
        return this.mappedClass;
    }

    public Cascades.CascadeStyle[] getPropertyCascadeStyles() {
        return this.cascadeStyles;
    }

    private void setPropertyValuesWithOptimizer(Object object, Object[] values) {
        try {
            this.optimizer.setPropertyValues(object, values);
        }
        catch (Throwable t) {
            throw new PropertyAccessException(t, "exception setting property value with CGLIB (set hibernate.cglib.use_reflection_optimizer=false for more info)", true, this.mappedClass, ReflectHelper.getPropertyName(t, this.optimizer));
        }
    }

    private Object[] getPropertyValuesWithOptimizer(Object object) {
        try {
            return this.optimizer.getPropertyValues(object);
        }
        catch (Throwable t) {
            throw new PropertyAccessException(t, "exception getting property value with CGLIB (set hibernate.cglib.use_reflection_optimizer=false for more info)", false, this.mappedClass, ReflectHelper.getPropertyName(t, this.optimizer));
        }
    }

    public EntityPersister getSubclassEntityPersister(Object instance, SessionFactoryImplementor factory) {
        if (!this.hasSubclasses()) {
            return this;
        }
        Class<?> clazz = instance.getClass();
        if (clazz == this.getMappedClass()) {
            return this;
        }
        String subclassEntityName = this.getSubclassEntityName(clazz);
        if (subclassEntityName == null) {
            throw new HibernateException("instance not of expected entity type: " + this.getEntityName());
        }
        return factory.getEntityPersister(subclassEntityName);
    }

    private String getSubclassEntityName(Class clazz) {
        return (String)this.entityNameBySubclass.get(clazz);
    }

    public void setPropertyValues(Object object, Object[] values) throws HibernateException {
        boolean setAll;
        boolean bl = setAll = !this.hasLazyProperties();
        if (setAll && this.optimizer != null) {
            this.setPropertyValuesWithOptimizer(object, values);
        } else {
            for (int j = 0; j < this.getPropertySpan(); ++j) {
                if (!setAll && values[j] == LazyPropertyInitializer.UNFETCHED_PROPERTY) continue;
                this.getSetters()[j].set(object, values[j]);
            }
        }
    }

    public Object[] getPropertyValues(Object object) throws HibernateException {
        boolean getAll;
        boolean bl = getAll = !this.hasLazyProperties() || !this.hasUninitializedLazyProperties(object);
        if (getAll && this.optimizer != null) {
            return this.getPropertyValuesWithOptimizer(object);
        }
        int span = this.getPropertySpan();
        Object[] result = new Object[span];
        for (int j = 0; j < span; ++j) {
            result[j] = getAll || !this.propertyLaziness[j] ? this.getGetters()[j].get(object) : LazyPropertyInitializer.UNFETCHED_PROPERTY;
        }
        return result;
    }

    public Object getPropertyValue(Object object, int i) throws HibernateException {
        return this.getGetters()[i].get(object);
    }

    public void setPropertyValue(Object object, int i, Object value) throws HibernateException {
        this.getSetters()[i].set(object, value);
    }

    protected boolean[] getPropertyCheckability(Object entity) {
        return this.hasUninitializedLazyProperties(entity) ? this.propertyCheckability : this.propertyUpdateability;
    }

    protected boolean[] getPropertyCheckability() {
        return this.propertyCheckability;
    }

    private void logDirtyProperties(int[] props) {
        if (log.isTraceEnabled()) {
            for (int i = 0; i < props.length; ++i) {
                log.trace((Object)(StringHelper.qualify(this.entityName, this.propertyNames[props[i]]) + " is dirty"));
            }
        }
    }

    public int[] findDirty(Object[] x, Object[] y, Object object, SessionImplementor session) throws HibernateException {
        int[] props = TypeFactory.findDirty(this.propertyTypes, x, y, this.getPropertyCheckability(object), session);
        if (props == null) {
            return null;
        }
        this.logDirtyProperties(props);
        return props;
    }

    public int[] findModified(Object[] old, Object[] current, Object object, SessionImplementor session) throws HibernateException {
        int[] props = TypeFactory.findModified(this.propertyTypes, old, current, this.getPropertyCheckability(object), session);
        if (props == null) {
            return null;
        }
        this.logDirtyProperties(props);
        return props;
    }

    public Serializable getIdentifier(Object object) throws HibernateException {
        Object id;
        if (this.hasEmbeddedIdentifier) {
            id = object;
        } else {
            if (this.identifierGetter == null) {
                throw new HibernateException("The class has no identifier property: " + this.entityName);
            }
            id = this.identifierGetter.get(object);
        }
        try {
            return (Serializable)id;
        }
        catch (ClassCastException cce) {
            StringBuffer msg = new StringBuffer("Identifier classes must be serializable. ");
            if (id != null) {
                msg.append(id.getClass().getName() + " is not serializable. ");
            }
            if (cce.getMessage() != null) {
                msg.append(cce.getMessage());
            }
            throw new ClassCastException(msg.toString());
        }
    }

    public Object getVersion(Object object) throws HibernateException {
        if (!this.versioned) {
            return null;
        }
        return this.versionGetter.get(object);
    }

    public void setIdentifier(Object object, Serializable id) throws HibernateException {
        if (this.hasEmbeddedIdentifier) {
            if (object != id) {
                AbstractComponentType copier = (AbstractComponentType)this.identifierType;
                copier.setPropertyValues(object, copier.getPropertyValues(id));
            }
        } else if (this.identifierSetter != null) {
            this.identifierSetter.set(object, id);
        }
    }

    /*
     * WARNING - void declaration
     */
    public Object instantiate(Serializable id) throws HibernateException {
        void var2_2;
        HashMap<String, String> result;
        if (this.hasEmbeddedIdentifier && id != null && id.getClass().equals(this.mappedClass)) {
            return id;
        }
        if (this.abstractClass) {
            throw new HibernateException("Cannot instantiate abstract class or interface: " + this.entityName);
        }
        if (this.optimizer != null) {
            try {
                result = this.fastClass.newInstance();
            }
            catch (Throwable t) {
                throw new InstantiationException("Could not instantiate entity with CGLIB: ", this.mappedClass, t);
            }
        }
        if (this.isDynamic) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("type", this.getEntityName());
            result = map;
        } else {
            if (this.constructor == null) {
                throw new InstantiationException("No default constructor for entity: ", this.mappedClass);
            }
            try {
                result = this.constructor.newInstance(null);
            }
            catch (Exception e) {
                throw new InstantiationException("Could not instantiate entity: ", this.mappedClass, e);
            }
        }
        if (id != null) {
            this.setIdentifier(var2_2, id);
        }
        return var2_2;
    }

    public void afterInitialize(Object entity, boolean lazyPropertiesAreUnfetched, SessionImplementor session) {
        if (lazyPropertiesAreUnfetched && this.hasLazyProperties()) {
            ((InterceptFieldEnabled)entity).setInterceptFieldCallback((InterceptFieldCallback)new FieldInterceptor(session, this.getEntityName(), this.getLazyProperties()));
        }
    }

    protected Set getLazyProperties() {
        throw new AssertionFailure("no lazy property support");
    }

    protected Setter[] getSetters() {
        return this.setters;
    }

    protected Getter[] getGetters() {
        return this.getters;
    }

    public Type[] getPropertyTypes() {
        return this.propertyTypes;
    }

    public Type getIdentifierType() {
        return this.identifierType;
    }

    public boolean isPolymorphic() {
        return this.polymorphic;
    }

    public boolean isInherited() {
        return this.inherited;
    }

    public boolean hasCascades() {
        return this.hasCascades;
    }

    public CacheConcurrencyStrategy getCache() {
        return this.cache;
    }

    public boolean hasIdentifierProperty() {
        return this.identifierGetter != null;
    }

    public VersionType getVersionType() {
        return this.versionType;
    }

    public int getVersionProperty() {
        return this.versionProperty;
    }

    public boolean isVersioned() {
        return this.versioned;
    }

    public boolean isIdentifierAssignedByInsert() {
        return this.isIdentifierAssignedByInsert;
    }

    protected boolean hasLazyProperties() {
        return this.hasLazyProperties;
    }

    public boolean hasUninitializedLazyProperties(Object entity) {
        if (this.hasLazyProperties()) {
            InterceptFieldCallback callback = ((InterceptFieldEnabled)entity).getInterceptFieldCallback();
            return callback != null && !((FieldInterceptor)callback).isInitialized();
        }
        return false;
    }

    public void afterReassociate(Object entity, SessionImplementor session) {
        InterceptFieldCallback interceptor;
        if (this.hasLazyProperties() && (interceptor = ((InterceptFieldEnabled)entity).getInterceptFieldCallback()) != null) {
            ((FieldInterceptor)interceptor).setSession(session);
        }
    }

    public Boolean isTransient(Object entity, SessionImplementor session) throws HibernateException {
        Boolean result;
        Serializable id = this.hasIdentifierPropertyOrEmbeddedCompositeIdentifier() ? this.getIdentifier(entity) : null;
        if (id == null) {
            return Boolean.TRUE;
        }
        Object version = this.getVersion(entity);
        if (this.isVersioned() && (result = this.unsavedVersionValue.isUnsaved(version)) != null) {
            return result;
        }
        result = this.unsavedIdentifierValue.isUnsaved(id);
        if (result != null) {
            return result;
        }
        if (this.hasCache()) {
            CacheKey ck = new CacheKey(id, this.getIdentifierType(), this.getRootEntityName());
            if (this.getCache().get(ck, session.getTimestamp()) != null) {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    public String[] getPropertyNames() {
        return this.propertyNames;
    }

    public String getIdentifierPropertyName() {
        return this.identifierPropertyName;
    }

    public boolean implementsLifecycle() {
        return this.implementsLifecycle;
    }

    public boolean implementsValidatable() {
        return this.implementsValidatable;
    }

    public boolean hasCollections() {
        return this.hasCollections;
    }

    public boolean isMutable() {
        return this.mutable;
    }

    public boolean hasCache() {
        return this.cache != null;
    }

    public boolean hasSubclasses() {
        return this.hasSubclasses;
    }

    public boolean hasProxy() {
        return this.isLazy;
    }

    public IdentifierGenerator getIdentifierGenerator() throws HibernateException {
        return this.identifierGenerator;
    }

    public String getRootEntityName() {
        return this.rootEntityName;
    }

    protected ProxyFactory createProxyFactory() {
        return this.isDynamic ? new MapProxyFactory() : new CGLIBProxyFactory();
    }

    private boolean initHasCollections() {
        return this.initHasCollections(this.propertyTypes);
    }

    private boolean initHasCollections(Type[] types) {
        for (int i = 0; i < types.length; ++i) {
            if (types[i].isPersistentCollectionType()) {
                return true;
            }
            if (!types[i].isComponentType() || !this.initHasCollections(((AbstractComponentType)types[i]).getSubtypes())) continue;
            return true;
        }
        return false;
    }

    public boolean[] getPropertyLaziness() {
        return this.propertyLaziness;
    }

    public ClassMetadata getClassMetadata() {
        return this;
    }

    public Class getConcreteProxyClass() {
        return this.concreteProxyClass;
    }

    public String getMappedSuperclass() {
        return this.superclass;
    }

    public boolean isExplicitPolymorphism() {
        return this.explicitPolymorphism;
    }

    public boolean[] getPropertyUpdateability() {
        return this.propertyUpdateability;
    }

    public boolean[] getPropertyNullability() {
        return this.propertyNullability;
    }

    protected boolean useDynamicUpdate() {
        return this.dynamicUpdate;
    }

    protected boolean useDynamicInsert() {
        return this.dynamicInsert;
    }

    public boolean[] getPropertyInsertability() {
        return this.propertyInsertability;
    }

    public Object getPropertyValue(Object object, String propertyName) throws HibernateException {
        Getter getter = (Getter)this.gettersByPropertyName.get(propertyName);
        if (getter == null) {
            throw new HibernateException("unmapped property: " + propertyName);
        }
        return getter.get(object);
    }

    public void setPropertyValue(Object object, String propertyName, Object value) throws HibernateException {
        Setter setter = (Setter)this.settersByPropertyName.get(propertyName);
        if (setter == null) {
            throw new HibernateException("unmapped property: " + propertyName);
        }
        setter.set(object, value);
    }

    protected boolean hasEmbeddedIdentifier() {
        return this.hasEmbeddedIdentifier;
    }

    public boolean hasIdentifierPropertyOrEmbeddedCompositeIdentifier() {
        return this.hasIdentifierProperty() || this.hasEmbeddedIdentifier;
    }

    public Type getType() {
        return this.entityType;
    }

    protected int getPropertySpan() {
        return this.propertySpan;
    }

    public String[] getKeyColumnNames() {
        return this.getIdentifierColumnNames();
    }

    public String getName() {
        return this.getEntityName();
    }

    public boolean isCollection() {
        return false;
    }

    public boolean consumesAlias() {
        return true;
    }

    public Type getPropertyType(String propertyName) throws MappingException {
        Type propertyType = (Type)this.typesByPropertyName.get(propertyName);
        if (propertyType == null) {
            throw new MappingException("property does not exist: " + propertyName);
        }
        return propertyType;
    }

    public boolean isSelectBeforeUpdateRequired() {
        return this.selectBeforeUpdate;
    }

    protected final int optimisticLockMode() {
        return this.optimisticLockMode;
    }

    public Object createProxy(Serializable id, SessionImplementor session) throws HibernateException {
        return this.proxyFactory.getProxy(id, session);
    }

    protected boolean[] getPropertiesToInsert(Object[] fields) {
        boolean[] notNull = new boolean[fields.length];
        boolean[] insertable = this.getPropertyInsertability();
        for (int i = 0; i < fields.length; ++i) {
            notNull[i] = insertable[i] && fields[i] != null;
        }
        return notNull;
    }

    protected final boolean[] getPropertiesToUpdate(int[] dirtyProperties, boolean hasDirtyCollection) {
        boolean[] propsToUpdate = new boolean[this.getPropertySpan()];
        for (int j = 0; j < dirtyProperties.length; ++j) {
            propsToUpdate[dirtyProperties[j]] = true;
        }
        if (this.isVersioned()) {
            propsToUpdate[this.getVersionProperty()] = Versioning.isVersionIncrementRequired(dirtyProperties, hasDirtyCollection, this.propertyVersionability);
        }
        return propsToUpdate;
    }

    public String toString() {
        return StringHelper.unqualify(this.getClass().getName()) + '(' + this.entityName + ')';
    }

    public boolean isDynamic() {
        return this.isDynamic;
    }

    public boolean isInstance(Object object) {
        if (this.isDynamic) {
            if (object instanceof Map) {
                String type = (String)((Map)object).get("type");
                return type == null || this.entityName.equals(type);
            }
            return false;
        }
        return this.mappedClass.isInstance(object);
    }

    protected SessionFactoryImplementor getFactory() {
        return this.factory;
    }

    public final String selectFragment(String alias, String suffix, boolean includeCollectionColumns) {
        return this.selectFragment(alias, suffix);
    }

    protected boolean isLazyAvailable() {
        return (class$net$sf$cglib$transform$impl$InterceptFieldEnabled == null ? (class$net$sf$cglib$transform$impl$InterceptFieldEnabled = AbstractEntityPersister.class$("net.sf.cglib.transform.impl.InterceptFieldEnabled")) : class$net$sf$cglib$transform$impl$InterceptFieldEnabled).isAssignableFrom(this.getMappedClass());
    }

    public void resetIdentifier(Object entity, Serializable currentId, Object currentVersion) {
        if (!(this.identifierGenerator instanceof Assigned)) {
            Serializable result = this.unsavedIdentifierValue.getDefaultValue(currentId);
            this.setIdentifier(entity, result);
            if (this.isVersioned()) {
                this.setPropertyValue(entity, this.versionProperty, this.unsavedVersionValue.getDefaultValue(currentVersion));
            }
        }
    }

    public boolean[] getPropertyVersionability() {
        return this.propertyVersionability;
    }

    public CacheEntryStructure getCacheEntryStructure() {
        return this.cacheEntryStructure;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

