/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.hibernate.AssertionFailure;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.QueryException;
import org.hibernate.cache.CacheConcurrencyStrategy;
import org.hibernate.engine.Mapping;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.Subclass;
import org.hibernate.mapping.Table;
import org.hibernate.persister.BasicEntityPersister;
import org.hibernate.sql.CaseFragment;
import org.hibernate.sql.SelectFragment;
import org.hibernate.type.Type;
import org.hibernate.util.ArrayHelper;

public class JoinedSubclassEntityPersister
extends BasicEntityPersister {
    private final int tableSpan;
    private final String[] tableNames;
    private final String[] naturalOrderTableNames;
    private final String[][] tableKeyColumns;
    private final String[][] naturalOrderTableKeyColumns;
    private final boolean[] naturalOrderCascadeDeleteEnabled;
    private final String[] spaces;
    private final String[] subclassClosure;
    private final String[] subclassTableNameClosure;
    private final String[][] subclassTableKeyColumnClosure;
    private final boolean[] isClassOrSuperclassTable;
    private final int[] naturalOrderPropertyTableNumbers;
    private final int[] propertyTableNumbers;
    private final int[] subclassPropertyTableNumberClosure;
    private final int[] subclassColumnTableNumberClosure;
    private final int[] subclassFormulaTableNumberClosure;
    private final Map subclassesByDiscriminatorValue = new HashMap();
    private final String[] discriminatorValues;
    private final String[] notNullColumnNames;
    private final int[] notNullColumnTableNumbers;
    private final String discriminatorSQLString;

    public JoinedSubclassEntityPersister(PersistentClass persistentClass, CacheConcurrencyStrategy cache, SessionFactoryImplementor factory, Mapping mapping) throws HibernateException {
        super(persistentClass, cache, factory);
        Integer discriminatorValue;
        if (persistentClass.isPolymorphic()) {
            try {
                discriminatorValue = new Integer(persistentClass.getSubclassId());
                this.discriminatorSQLString = ((Object)discriminatorValue).toString();
            }
            catch (Exception e) {
                throw new MappingException("Could not format discriminator value to SQL string", e);
            }
        } else {
            discriminatorValue = null;
            this.discriminatorSQLString = null;
        }
        if (this.optimisticLockMode() != 0) {
            throw new MappingException("optimistic-lock attribute not supported for joined-subclass mappings: " + this.getEntityName());
        }
        int idColumnSpan = this.getIdentifierColumnSpan();
        ArrayList<String> tables = new ArrayList<String>();
        ArrayList<String[]> keyColumns = new ArrayList<String[]>();
        ArrayList<Boolean> cascadeDeletes = new ArrayList<Boolean>();
        Iterator titer = persistentClass.getTableClosureIterator();
        Iterator kiter = persistentClass.getKeyClosureIterator();
        while (titer.hasNext()) {
            Table tab = (Table)titer.next();
            KeyValue key = (KeyValue)kiter.next();
            String tabname = tab.getQualifiedName(factory.getDialect(), factory.getSettings().getDefaultCatalogName(), factory.getSettings().getDefaultSchemaName());
            tables.add(tabname);
            String[] keyCols = new String[idColumnSpan];
            Iterator citer = key.getColumnIterator();
            for (int k = 0; k < idColumnSpan; ++k) {
                keyCols[k] = ((Column)citer.next()).getQuotedName(factory.getDialect());
            }
            keyColumns.add(keyCols);
            cascadeDeletes.add(new Boolean(key.isCascadeDeleteEnabled() && factory.getDialect().supportsCascadeDelete()));
        }
        this.naturalOrderTableNames = ArrayHelper.toStringArray(tables);
        this.naturalOrderTableKeyColumns = ArrayHelper.to2DStringArray(keyColumns);
        this.naturalOrderCascadeDeleteEnabled = ArrayHelper.toBooleanArray(cascadeDeletes);
        ArrayList<String> subtables = new ArrayList<String>();
        ArrayList<Boolean> isConcretes = new ArrayList<Boolean>();
        keyColumns = new ArrayList();
        titer = persistentClass.getSubclassTableClosureIterator();
        while (titer.hasNext()) {
            Table tab = (Table)titer.next();
            isConcretes.add(new Boolean(persistentClass.isClassOrSuperclassTable(tab)));
            String tabname = tab.getQualifiedName(factory.getDialect(), factory.getSettings().getDefaultCatalogName(), factory.getSettings().getDefaultSchemaName());
            subtables.add(tabname);
            String[] key = new String[idColumnSpan];
            Iterator citer = tab.getPrimaryKey().getColumnIterator();
            for (int k = 0; k < idColumnSpan; ++k) {
                key[k] = ((Column)citer.next()).getQuotedName(factory.getDialect());
            }
            keyColumns.add(key);
        }
        this.subclassTableNameClosure = ArrayHelper.toStringArray(subtables);
        this.subclassTableKeyColumnClosure = ArrayHelper.to2DStringArray(keyColumns);
        this.isClassOrSuperclassTable = ArrayHelper.toBooleanArray(isConcretes);
        this.tableSpan = this.naturalOrderTableNames.length;
        this.tableNames = JoinedSubclassEntityPersister.reverse(this.naturalOrderTableNames);
        this.tableKeyColumns = JoinedSubclassEntityPersister.reverse(this.naturalOrderTableKeyColumns);
        JoinedSubclassEntityPersister.reverse(this.subclassTableNameClosure, this.tableSpan);
        JoinedSubclassEntityPersister.reverse((Object[])this.subclassTableKeyColumnClosure, this.tableSpan);
        this.spaces = ArrayHelper.join(this.tableNames, ArrayHelper.toStringArray(persistentClass.getSynchronizedTables()));
        this.customSQLInsert = new String[this.tableSpan];
        this.customSQLUpdate = new String[this.tableSpan];
        this.customSQLDelete = new String[this.tableSpan];
        this.insertCallable = new boolean[this.tableSpan];
        this.updateCallable = new boolean[this.tableSpan];
        this.deleteCallable = new boolean[this.tableSpan];
        int jk = this.tableSpan - 1;
        for (PersistentClass pc = persistentClass; pc != null; pc = pc.getSuperclass()) {
            this.customSQLInsert[jk] = pc.getCustomSQLInsert();
            this.customSQLUpdate[jk] = pc.getCustomSQLUpdate();
            this.customSQLDelete[jk] = pc.getCustomSQLDelete();
            this.insertCallable[jk] = pc.isCustomInsertCallable();
            this.updateCallable[jk] = pc.isCustomUpdateCallable();
            this.deleteCallable[jk] = pc.isCustomDeleteCallable();
            --jk;
        }
        if (jk != -1) {
            throw new AssertionFailure("Tablespan does not match height of joined-subclass hiearchy.");
        }
        int hydrateSpan = this.getPropertySpan();
        this.naturalOrderPropertyTableNumbers = new int[hydrateSpan];
        this.propertyTableNumbers = new int[hydrateSpan];
        Iterator iter = persistentClass.getPropertyClosureIterator();
        int i = 0;
        while (iter.hasNext()) {
            Property prop = (Property)iter.next();
            String tabname = prop.getValue().getTable().getQualifiedName(factory.getDialect(), factory.getSettings().getDefaultCatalogName(), factory.getSettings().getDefaultSchemaName());
            this.propertyTableNumbers[i] = JoinedSubclassEntityPersister.getTableId(tabname, this.tableNames);
            this.naturalOrderPropertyTableNumbers[i] = JoinedSubclassEntityPersister.getTableId(tabname, this.naturalOrderTableNames);
            ++i;
        }
        ArrayList<Integer> columnTableNumbers = new ArrayList<Integer>();
        ArrayList<Integer> formulaTableNumbers = new ArrayList<Integer>();
        ArrayList<Integer> propTableNumbers = new ArrayList<Integer>();
        iter = persistentClass.getSubclassPropertyClosureIterator();
        while (iter.hasNext()) {
            Property prop = (Property)iter.next();
            Table tab = prop.getValue().getTable();
            String tabname = tab.getQualifiedName(factory.getDialect(), factory.getSettings().getDefaultCatalogName(), factory.getSettings().getDefaultSchemaName());
            Integer tabnum = new Integer(JoinedSubclassEntityPersister.getTableId(tabname, this.subclassTableNameClosure));
            propTableNumbers.add(tabnum);
            Iterator citer = prop.getColumnIterator();
            while (citer.hasNext()) {
                Selectable thing = (Selectable)citer.next();
                if (thing.isFormula()) {
                    formulaTableNumbers.add(tabnum);
                    continue;
                }
                columnTableNumbers.add(tabnum);
            }
        }
        this.subclassColumnTableNumberClosure = ArrayHelper.toIntArray(columnTableNumbers);
        this.subclassPropertyTableNumberClosure = ArrayHelper.toIntArray(propTableNumbers);
        this.subclassFormulaTableNumberClosure = ArrayHelper.toIntArray(formulaTableNumbers);
        int subclassSpan = persistentClass.getSubclassSpan() + 1;
        this.subclassClosure = new String[subclassSpan];
        this.subclassClosure[subclassSpan - 1] = this.getEntityName();
        if (persistentClass.isPolymorphic()) {
            int id;
            this.subclassesByDiscriminatorValue.put(discriminatorValue, this.getEntityName());
            this.discriminatorValues = new String[subclassSpan];
            this.discriminatorValues[subclassSpan - 1] = this.discriminatorSQLString;
            this.notNullColumnTableNumbers = new int[subclassSpan];
            this.notNullColumnTableNumbers[subclassSpan - 1] = id = JoinedSubclassEntityPersister.getTableId(persistentClass.getTable().getQualifiedName(factory.getDialect(), factory.getSettings().getDefaultCatalogName(), factory.getSettings().getDefaultSchemaName()), this.subclassTableNameClosure);
            this.notNullColumnNames = new String[subclassSpan];
            this.notNullColumnNames[subclassSpan - 1] = this.subclassTableKeyColumnClosure[id][0];
        } else {
            this.discriminatorValues = null;
            this.notNullColumnTableNumbers = null;
            this.notNullColumnNames = null;
        }
        iter = persistentClass.getSubclassIterator();
        int k = 0;
        while (iter.hasNext()) {
            Subclass sc = (Subclass)iter.next();
            this.subclassClosure[k] = sc.getEntityName();
            try {
                if (persistentClass.isPolymorphic()) {
                    int id;
                    Integer subclassId = new Integer(sc.getSubclassId());
                    this.subclassesByDiscriminatorValue.put(subclassId, sc.getEntityName());
                    this.discriminatorValues[k] = subclassId.toString();
                    this.notNullColumnTableNumbers[k] = id = JoinedSubclassEntityPersister.getTableId(sc.getTable().getQualifiedName(factory.getDialect(), factory.getSettings().getDefaultCatalogName(), factory.getSettings().getDefaultSchemaName()), this.subclassTableNameClosure);
                    this.notNullColumnNames[k] = this.subclassTableKeyColumnClosure[id][0];
                }
            }
            catch (Exception e) {
                throw new MappingException("Error parsing discriminator value", e);
            }
            ++k;
        }
        this.initLockers();
        this.initSubclassPropertyAliasesMap(persistentClass);
        this.postConstruct(mapping);
    }

    public String getSubclassPropertyTableName(int i) {
        return this.subclassTableNameClosure[this.subclassPropertyTableNumberClosure[i]];
    }

    public Type getDiscriminatorType() {
        return Hibernate.INTEGER;
    }

    public Object getDiscriminatorSQLValue() {
        return this.discriminatorSQLString;
    }

    public String getSubclassForDiscriminatorValue(Object value) {
        return (String)this.subclassesByDiscriminatorValue.get(value);
    }

    public Serializable[] getPropertySpaces() {
        return this.spaces;
    }

    protected String getTableName(int j) {
        return this.naturalOrderTableNames[j];
    }

    protected String[] getKeyColumns(int j) {
        return this.naturalOrderTableKeyColumns[j];
    }

    protected boolean isTableCascadeDeleteEnabled(int j) {
        return this.naturalOrderCascadeDeleteEnabled[j];
    }

    protected boolean isPropertyOfTable(int property, int j) {
        return this.naturalOrderPropertyTableNumbers[property] == j;
    }

    private static final void reverse(Object[] objects, int len) {
        int i;
        Object[] temp = new Object[len];
        for (i = 0; i < len; ++i) {
            temp[i] = objects[len - i - 1];
        }
        for (i = 0; i < len; ++i) {
            objects[i] = temp[i];
        }
    }

    private static final String[] reverse(String[] objects) {
        int len = objects.length;
        String[] temp = new String[len];
        for (int i = 0; i < len; ++i) {
            temp[i] = objects[len - i - 1];
        }
        return temp;
    }

    private static final String[][] reverse(String[][] objects) {
        int len = objects.length;
        String[][] temp = new String[len][];
        for (int i = 0; i < len; ++i) {
            temp[i] = objects[len - i - 1];
        }
        return temp;
    }

    public String fromTableFragment(String alias) {
        return this.getTableName() + ' ' + alias;
    }

    public String getTableName() {
        return this.tableNames[0];
    }

    private static int getTableId(String tableName, String[] tables) {
        for (int j = 0; j < tables.length; ++j) {
            if (!tableName.equals(tables[j])) continue;
            return j;
        }
        throw new AssertionFailure("table not found");
    }

    public void addDiscriminatorToSelect(SelectFragment select, String name, String suffix) {
        if (this.hasSubclasses()) {
            select.setExtraSelectList(this.discriminatorFragment(name), this.getDiscriminatorAlias());
        }
    }

    private CaseFragment discriminatorFragment(String alias) {
        CaseFragment cases = this.getFactory().getDialect().createCaseFragment();
        for (int i = 0; i < this.discriminatorValues.length; ++i) {
            cases.addWhenColumnNotNull(this.generateTableAlias(alias, this.notNullColumnTableNumbers[i]), this.notNullColumnNames[i], this.discriminatorValues[i]);
        }
        return cases;
    }

    public String filterFragment(String alias) {
        return this.hasWhere() ? " and " + this.getSQLWhereString(this.generateTableAlias(alias, this.tableSpan - 1)) : "";
    }

    public String[] getIdentifierColumnNames() {
        return this.tableKeyColumns[0];
    }

    public String[] toColumns(String alias, String propertyName) throws QueryException {
        if ("class".equals(propertyName)) {
            return new String[]{this.discriminatorFragment(alias).toFragmentString()};
        }
        return super.toColumns(alias, propertyName);
    }

    protected int[] getPropertyTableNumbersInSelect() {
        return this.propertyTableNumbers;
    }

    protected int getSubclassPropertyTableNumber(int i) {
        return this.subclassPropertyTableNumberClosure[i];
    }

    protected int getTableSpan() {
        return this.tableSpan;
    }

    protected int[] getSubclassColumnTableNumberClosure() {
        return this.subclassColumnTableNumberClosure;
    }

    protected int[] getSubclassFormulaTableNumberClosure() {
        return this.subclassFormulaTableNumberClosure;
    }

    protected int[] getPropertyTableNumbers() {
        return this.naturalOrderPropertyTableNumbers;
    }

    protected String[] getSubclassTableKeyColumns(int j) {
        return this.subclassTableKeyColumnClosure[j];
    }

    protected String getSubclassTableName(int j) {
        return this.subclassTableNameClosure[j];
    }

    protected int getSubclassTableSpan() {
        return this.subclassTableNameClosure.length;
    }

    protected boolean isClassOrSuperclassTable(int j) {
        return this.isClassOrSuperclassTable[j];
    }

    public String getPropertyTableName(String propertyName) {
        return this.tableNames[this.propertyTableNumbers[this.getPropertyIndex(propertyName)]];
    }
}

