/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.AssertionFailure;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.loader.UniqueEntityLoader;
import org.hibernate.persister.EntityPersister;

public final class NamedQueryLoader
implements UniqueEntityLoader {
    private final String queryName;
    private final EntityPersister persister;
    private static final Log log = LogFactory.getLog((Class)(class$org$hibernate$persister$NamedQueryLoader == null ? (class$org$hibernate$persister$NamedQueryLoader = NamedQueryLoader.class$("org.hibernate.persister.NamedQueryLoader")) : class$org$hibernate$persister$NamedQueryLoader));
    static /* synthetic */ Class class$org$hibernate$persister$NamedQueryLoader;

    public NamedQueryLoader(String queryName, EntityPersister persister) {
        this.queryName = queryName;
        this.persister = persister;
    }

    public Object load(Serializable id, Object optionalObject, SessionImplementor session) throws HibernateException {
        Query query;
        if (optionalObject != null) {
            throw new AssertionFailure("cannot supply object to query loader");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("loading entity: " + this.persister.getEntityName() + " using named query: " + this.queryName));
        }
        if ((query = session.getNamedQuery(this.queryName)).getNamedParameters().length > 0) {
            query.setParameter(query.getNamedParameters()[0], (Object)id, this.persister.getIdentifierType());
        } else {
            query.setParameter(0, (Object)id, this.persister.getIdentifierType());
        }
        query.setFlushMode(FlushMode.NEVER).list();
        return session.getEntity(new EntityKey(id, this.persister));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

