/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.entity;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.AssertionFailure;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.loader.entity.UniqueEntityLoader;
import org.hibernate.persister.entity.EntityPersister;

public final class NamedQueryLoader
implements UniqueEntityLoader {
    private final String queryName;
    private final EntityPersister persister;
    private static final Log log;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.hibernate.persister.entity.NamedQueryLoader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public NamedQueryLoader(String queryName, EntityPersister persister) {
        this.queryName = queryName;
        this.persister = persister;
    }

    public Object load(Serializable id, Object optionalObject, SessionImplementor session) throws HibernateException {
        Query query;
        if (optionalObject != null) {
            throw new AssertionFailure("cannot supply object to query loader");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("loading entity: " + this.persister.getEntityName() + " using named query: " + this.queryName));
        }
        if ((query = session.getNamedQuery(this.queryName)).getNamedParameters().length > 0) {
            query.setParameter(query.getNamedParameters()[0], (Object)id, this.persister.getIdentifierType());
        } else {
            query.setParameter(0, (Object)id, this.persister.getIdentifierType());
        }
        query.setFlushMode(FlushMode.NEVER).list();
        return session.getPersistenceContext().getEntity(new EntityKey(id, this.persister, session.getEntityMode()));
    }
}

