/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2ddl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.FileSet;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.tool.hbm2ddl.SchemaUpdate;
import org.hibernate.util.ArrayHelper;
import org.hibernate.util.ReflectHelper;

public class SchemaUpdateTask
extends MatchingTask {
    private List fileSets = new LinkedList();
    private File propertiesFile = null;
    private String configurationFile = null;
    private boolean quiet = false;
    private boolean text = true;
    private String namingStrategy = null;

    public void addFileset(FileSet set) {
        this.fileSets.add(set);
    }

    public void setProperties(File propertiesFile) {
        if (!propertiesFile.exists()) {
            throw new BuildException("Properties file: " + propertiesFile + " does not exist.");
        }
        this.log("Using properties file " + propertiesFile, 4);
        this.propertiesFile = propertiesFile;
    }

    public void setConfig(String configurationFile) {
        this.configurationFile = configurationFile;
    }

    public void setText(boolean text) {
        this.text = text;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    public void execute() throws BuildException {
        try {
            Configuration cfg = this.getConfiguration();
            this.getSchemaUpdate(cfg).execute(!this.quiet, !this.text);
        }
        catch (HibernateException e) {
            throw new BuildException("Schema text failed: " + e.getMessage(), (Throwable)e);
        }
        catch (FileNotFoundException e) {
            throw new BuildException("File not found: " + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new BuildException("IOException : " + e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    private String[] getFiles() {
        LinkedList<String> files = new LinkedList<String>();
        Iterator i = this.fileSets.iterator();
        while (i.hasNext()) {
            FileSet fs = (FileSet)i.next();
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            String[] dsFiles = ds.getIncludedFiles();
            int j = 0;
            while (j < dsFiles.length) {
                File f = new File(dsFiles[j]);
                if (!f.isFile()) {
                    f = new File(ds.getBasedir(), dsFiles[j]);
                }
                files.add(f.getAbsolutePath());
                ++j;
            }
        }
        return ArrayHelper.toStringArray(files);
    }

    private Configuration getConfiguration() throws Exception {
        Configuration cfg = new Configuration();
        if (this.namingStrategy != null) {
            cfg.setNamingStrategy((NamingStrategy)ReflectHelper.classForName(this.namingStrategy).newInstance());
        }
        if (this.configurationFile != null) {
            cfg.configure(new File(this.configurationFile));
        }
        String[] files = this.getFiles();
        int i = 0;
        while (i < files.length) {
            String filename = files[i];
            if (filename.endsWith(".jar")) {
                cfg.addJar(new File(filename));
            } else {
                cfg.addFile(filename);
            }
            ++i;
        }
        return cfg;
    }

    private SchemaUpdate getSchemaUpdate(Configuration cfg) throws HibernateException, IOException {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)cfg.getProperties());
        if (this.propertiesFile == null) {
            properties.putAll((Map<?, ?>)this.getProject().getProperties());
        } else {
            properties.load(new FileInputStream(this.propertiesFile));
        }
        return new SchemaUpdate(cfg, properties);
    }

    public void setNamingStrategy(String namingStrategy) {
        this.namingStrategy = namingStrategy;
    }
}

