/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.instrument;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import net.sf.cglib.transform.AbstractTransformTask;
import net.sf.cglib.transform.ClassTransformer;
import net.sf.cglib.transform.impl.InterceptFieldFilter;
import net.sf.cglib.transform.impl.InterceptFieldTransformer;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.CodeVisitor;
import org.objectweb.asm.Type;

public class InstrumentTask
extends AbstractTransformTask {
    protected ClassTransformer getClassTransformer(String name) {
        return new InterceptFieldTransformer(new InterceptFieldFilter(){

            public boolean acceptRead(Type owner, String name) {
                return true;
            }

            public boolean acceptWrite(Type owner, String name) {
                return true;
            }
        });
    }

    protected void processFile(File clazzFile) throws Exception {
        if (clazzFile.getName().endsWith(".class")) {
            MatchingInterfaceClassVisitor mic = new MatchingInterfaceClassVisitor("net/sf/cglib/transform/impl/InterceptFieldEnabled");
            InstrumentTask.getClassReader(clazzFile).accept((ClassVisitor)mic, true);
            if (mic.found) {
                this.log(String.valueOf(clazzFile.getCanonicalPath()) + " already instrumented.", 1);
            } else {
                super.processFile(clazzFile);
            }
        } else {
            this.log("Skipping non .class file: " + clazzFile, 3);
        }
    }

    private static ClassReader getClassReader(File file) throws Exception {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
        ClassReader r = new ClassReader((InputStream)in);
        ((InputStream)in).close();
        return r;
    }

    public static class MatchingInterfaceClassVisitor
    implements ClassVisitor {
        private final String interfacename;
        private boolean found;

        public MatchingInterfaceClassVisitor(String interfacename) {
            this.interfacename = interfacename;
            this.found = false;
        }

        public void visitEnd() {
        }

        public void visitAttribute(Attribute attr) {
        }

        public CodeVisitor visitMethod(int arg0, String arg1, String arg2, String[] arg3, Attribute arg4) {
            return null;
        }

        public void visitField(int arg0, String arg1, String arg2, Object arg3, Attribute arg4) {
        }

        public void visitInnerClass(String name, String outerName, String innerName, int access) {
        }

        public void visit(int version, String name, String signature, String[] interfaces, String x) {
            int i = 0;
            while (i < interfaces.length) {
                String string = interfaces[i];
                if (this.interfacename.equals(string)) {
                    this.found = true;
                }
                ++i;
            }
        }
    }
}

