/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.transaction;

import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.Transaction;
import org.hibernate.jdbc.JDBCContext;
import org.hibernate.transaction.JTATransaction;
import org.hibernate.transaction.TransactionFactory;
import org.hibernate.transaction.TransactionManagerLookup;
import org.hibernate.transaction.TransactionManagerLookupFactory;
import org.hibernate.util.NamingHelper;

public class JTATransactionFactory
implements TransactionFactory {
    private static final Log log;
    private static final String DEFAULT_USER_TRANSACTION_NAME = "java:comp/UserTransaction";
    private InitialContext context;
    private String utName;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.hibernate.transaction.JTATransactionFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public void configure(Properties props) throws HibernateException {
        TransactionManagerLookup lookup;
        try {
            this.context = NamingHelper.getInitialContext(props);
        }
        catch (NamingException ne) {
            log.error((Object)"Could not obtain initial context", (Throwable)ne);
            throw new HibernateException("Could not obtain initial context", ne);
        }
        this.utName = props.getProperty("jta.UserTransaction");
        if (this.utName == null && (lookup = TransactionManagerLookupFactory.getTransactionManagerLookup(props)) != null) {
            this.utName = lookup.getUserTransactionName();
        }
        if (this.utName == null) {
            this.utName = DEFAULT_USER_TRANSACTION_NAME;
        }
    }

    public Transaction beginTransaction(JDBCContext jdbcContext, TransactionFactory.Context transactionContext) throws HibernateException {
        JTATransaction tx = new JTATransaction(jdbcContext, transactionContext);
        tx.begin(this.context, this.utName);
        return tx;
    }
}

