/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.transform;

import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.property.ChainedPropertyAccessor;
import org.hibernate.property.PropertyAccessor;
import org.hibernate.property.PropertyAccessorFactory;
import org.hibernate.property.Setter;
import org.hibernate.transform.ResultTransformer;

public class AliasToBeanResultTransformer
implements ResultTransformer {
    private final Class resultClass;
    private Setter[] setters;
    private PropertyAccessor propertyAccessor;

    public AliasToBeanResultTransformer(Class resultClass) {
        if (resultClass == null) {
            throw new IllegalArgumentException("resultClass cannot be null");
        }
        this.resultClass = resultClass;
        this.propertyAccessor = new ChainedPropertyAccessor(new PropertyAccessor[]{PropertyAccessorFactory.getPropertyAccessor(resultClass, null), PropertyAccessorFactory.getPropertyAccessor("field")});
    }

    public Object transformTuple(Object[] tuple, String[] aliases) {
        Object result;
        try {
            int i;
            if (this.setters == null) {
                this.setters = new Setter[aliases.length];
                i = 0;
                while (i < aliases.length) {
                    String alias = aliases[i];
                    if (alias != null) {
                        this.setters[i] = this.propertyAccessor.getSetter(this.resultClass, alias);
                    }
                    ++i;
                }
            }
            result = this.resultClass.newInstance();
            i = 0;
            while (i < aliases.length) {
                if (this.setters[i] != null) {
                    this.setters[i].set(result, tuple[i], null);
                }
                ++i;
            }
        }
        catch (InstantiationException instantiationException) {
            throw new HibernateException("Could not instantiate resultclass: " + this.resultClass.getName());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new HibernateException("Could not instantiate resultclass: " + this.resultClass.getName());
        }
        return result;
    }

    public List transformList(List collection) {
        return collection;
    }
}

