/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tuple;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.EntityMode;
import org.hibernate.MappingException;
import org.hibernate.PropertyNotFoundException;
import org.hibernate.engine.Cascades;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.tuple.EntityTuplizer;
import org.hibernate.tuple.IdentifierProperty;
import org.hibernate.tuple.PropertyFactory;
import org.hibernate.tuple.StandardProperty;
import org.hibernate.tuple.TuplizerLookup;
import org.hibernate.tuple.VersionProperty;
import org.hibernate.type.AbstractComponentType;
import org.hibernate.type.Type;
import org.hibernate.type.TypeFactory;
import org.hibernate.util.ArrayHelper;
import org.hibernate.util.ReflectHelper;

public class EntityMetamodel
implements Serializable {
    private static final Log log;
    private static final int NO_VERSION_INDX = -66;
    private final SessionFactoryImplementor sessionFactory;
    private final String name;
    private final String rootName;
    private final Type entityType;
    private final IdentifierProperty identifierProperty;
    private final boolean versioned;
    private final int propertySpan;
    private final int versionPropertyIndex;
    private final StandardProperty[] properties;
    private final String[] propertyNames;
    private final Type[] propertyTypes;
    private final boolean[] propertyLaziness;
    private final boolean[] propertyUpdateability;
    private final boolean[] propertyCheckability;
    private final boolean[] propertyInsertability;
    private final boolean[] propertyNullability;
    private final boolean[] propertyVersionability;
    private final Cascades.CascadeStyle[] cascadeStyles;
    private final Map propertyNameToIndexMap;
    private final boolean hasCollections;
    private final boolean hasLazyProperties;
    private final boolean lazy;
    private final boolean hasCascades;
    private final boolean mutable;
    private final boolean isAbstract;
    private final boolean selectBeforeUpdate;
    private final boolean dynamicUpdate;
    private final boolean dynamicInsert;
    private final int optimisticLockMode;
    private final boolean polymorphic;
    private final String superclass;
    private final boolean explicitPolymorphism;
    private final boolean inherited;
    private final boolean hasSubclasses;
    private final Set subclassEntityNames = new HashSet<E>();
    private final TuplizerLookup tuplizers;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.hibernate.tuple.EntityMetamodel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public EntityTuplizer getTuplizer(EntityMode entityMode) {
        return (EntityTuplizer)this.tuplizers.getTuplizer(entityMode);
    }

    public EntityTuplizer getTuplizerOrNull(EntityMode entityMode) {
        return (EntityTuplizer)this.tuplizers.getTuplizerOrNull(entityMode);
    }

    public EntityMode guessEntityMode(Object object) {
        return this.tuplizers.guessEntityMode(object);
    }

    /*
     * Unable to fully structure code
     */
    public EntityMetamodel(PersistentClass persistentClass, SessionFactoryImplementor sessionFactory) {
        super();
        this.sessionFactory = sessionFactory;
        this.name = persistentClass.getEntityName();
        this.rootName = persistentClass.getRootClass().getEntityName();
        this.entityType = TypeFactory.manyToOne(this.name);
        this.identifierProperty = PropertyFactory.buildIdentifierProperty(persistentClass, sessionFactory.getIdentifierGenerator(this.rootName));
        this.versioned = persistentClass.isVersioned();
        if (!persistentClass.hasPojoRepresentation()) ** GOTO lbl-1000
        v0 = EntityMetamodel.class$1;
        if (v0 == null) {
            try {
                v0 = EntityMetamodel.class$1 = Class.forName("net.sf.cglib.transform.impl.InterceptFieldEnabled");
            }
            catch (ClassNotFoundException v1) {
                throw new NoClassDefFoundError(v1.getMessage());
            }
        }
        if (v0.isAssignableFrom(persistentClass.getMappedClass())) {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = false;
        }
        lazyAvailable = v2;
        hasLazy = false;
        this.propertySpan = persistentClass.getPropertyClosureSpan();
        this.properties = new StandardProperty[this.propertySpan];
        this.propertyNames = new String[this.propertySpan];
        this.propertyTypes = new Type[this.propertySpan];
        this.propertyUpdateability = new boolean[this.propertySpan];
        this.propertyInsertability = new boolean[this.propertySpan];
        this.propertyCheckability = new boolean[this.propertySpan];
        this.propertyNullability = new boolean[this.propertySpan];
        this.propertyVersionability = new boolean[this.propertySpan];
        this.propertyLaziness = new boolean[this.propertySpan];
        this.cascadeStyles = new Cascades.CascadeStyle[this.propertySpan];
        iter = persistentClass.getPropertyClosureIterator();
        i = 0;
        tempVersionProperty = -66;
        foundCascade = false;
        foundCollection = false;
        tmpPropNameToIndexMap = new HashMap<String, Integer>();
        while (iter.hasNext()) {
            prop = (Property)iter.next();
            if (prop == persistentClass.getVersion()) {
                tempVersionProperty = i;
                this.properties[i] = PropertyFactory.buildVersionProperty(prop, lazyAvailable);
            } else {
                this.properties[i] = PropertyFactory.buildStandardProperty(prop, lazyAvailable);
            }
            this.propertyNames[i] = this.properties[i].getName();
            this.propertyTypes[i] = this.properties[i].getType();
            this.propertyNullability[i] = this.properties[i].isNullable();
            this.propertyUpdateability[i] = this.properties[i].isUpdateable();
            this.propertyInsertability[i] = this.properties[i].isInsertable();
            this.propertyVersionability[i] = this.properties[i].isVersionable();
            this.propertyLaziness[i] = lazy = prop.isLazy() != false && lazyAvailable != false;
            v3 = this.propertyCheckability[i] = this.properties[i].isUpdateable() != false && lazy == false;
            if (lazy) {
                hasLazy = true;
            }
            this.cascadeStyles[i] = this.properties[i].getCascadeStyle();
            if (this.properties[i].isLazy()) {
                hasLazy = true;
            }
            if (this.properties[i].getCascadeStyle() != Cascades.STYLE_NONE) {
                foundCascade = true;
            }
            if (this.indicatesCollection(this.properties[i].getType())) {
                foundCollection = true;
            }
            tmpPropNameToIndexMap.put(prop.getName(), new Integer(i));
            ++i;
        }
        this.hasCascades = foundCascade;
        this.versionPropertyIndex = tempVersionProperty;
        this.propertyNameToIndexMap = Collections.unmodifiableMap(tmpPropNameToIndexMap);
        this.hasLazyProperties = hasLazy;
        if (this.hasLazyProperties) {
            EntityMetamodel.log.info((Object)("lazy property fetching available for: " + this.name));
        }
        this.lazy = persistentClass.isLazy();
        this.mutable = persistentClass.isMutable();
        this.isAbstract = persistentClass.isAbstract() != false || persistentClass.hasPojoRepresentation() != false && ReflectHelper.isAbstractClass(persistentClass.getMappedClass()) != false;
        this.selectBeforeUpdate = persistentClass.hasSelectBeforeUpdate();
        this.dynamicUpdate = persistentClass.useDynamicUpdate();
        this.dynamicInsert = persistentClass.useDynamicInsert();
        this.polymorphic = persistentClass.isPolymorphic();
        this.explicitPolymorphism = persistentClass.isExplicitPolymorphism();
        this.inherited = persistentClass.isInherited();
        this.superclass = this.inherited != false ? persistentClass.getSuperclass().getEntityName() : null;
        this.hasSubclasses = persistentClass.hasSubclasses();
        this.optimisticLockMode = persistentClass.getOptimisticLockMode();
        if (this.optimisticLockMode > 0 && !this.dynamicUpdate) {
            throw new MappingException("optimistic-lock setting requires dynamic-update=\"true\": " + this.name);
        }
        this.hasCollections = foundCollection;
        this.tuplizers = TuplizerLookup.create(persistentClass, this);
        iter = persistentClass.getSubclassIterator();
        while (iter.hasNext()) {
            this.subclassEntityNames.add(((PersistentClass)iter.next()).getEntityName());
        }
        this.subclassEntityNames.add(this.name);
    }

    public Set getSubclassEntityNames() {
        return this.subclassEntityNames;
    }

    private boolean indicatesCollection(Type type) {
        if (type.isCollectionType()) {
            return true;
        }
        if (type.isComponentType()) {
            Type[] subtypes = ((AbstractComponentType)type).getSubtypes();
            int i = 0;
            while (i < subtypes.length) {
                if (this.indicatesCollection(subtypes[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public SessionFactoryImplementor getSessionFactory() {
        return this.sessionFactory;
    }

    public String getName() {
        return this.name;
    }

    public String getRootName() {
        return this.rootName;
    }

    public Type getEntityType() {
        return this.entityType;
    }

    public IdentifierProperty getIdentifierProperty() {
        return this.identifierProperty;
    }

    public int getPropertySpan() {
        return this.propertySpan;
    }

    public int getVersionPropertyIndex() {
        return this.versionPropertyIndex;
    }

    public VersionProperty getVersionProperty() {
        if (-66 == this.versionPropertyIndex) {
            return null;
        }
        return (VersionProperty)this.properties[this.versionPropertyIndex];
    }

    public StandardProperty[] getProperties() {
        return this.properties;
    }

    public int getPropertyIndex(StandardProperty property) throws PropertyNotFoundException {
        return this.getPropertyIndex(property.getName());
    }

    public int getPropertyIndex(String propertyName) throws PropertyNotFoundException {
        Integer index = (Integer)this.propertyNameToIndexMap.get(propertyName);
        if (index == null) {
            throw new PropertyNotFoundException("Unable to resolve property [name=" + propertyName + "] to corresponding index");
        }
        return index;
    }

    public boolean hasCollections() {
        return this.hasCollections;
    }

    public boolean hasLazyProperties() {
        return this.hasLazyProperties;
    }

    public boolean hasCascades() {
        return this.hasCascades;
    }

    public boolean isMutable() {
        return this.mutable;
    }

    public boolean isSelectBeforeUpdate() {
        return this.selectBeforeUpdate;
    }

    public boolean isDynamicUpdate() {
        return this.dynamicUpdate;
    }

    public boolean isDynamicInsert() {
        return this.dynamicInsert;
    }

    public int getOptimisticLockMode() {
        return this.optimisticLockMode;
    }

    public boolean isPolymorphic() {
        return this.polymorphic;
    }

    public String getSuperclass() {
        return this.superclass;
    }

    public boolean isExplicitPolymorphism() {
        return this.explicitPolymorphism;
    }

    public boolean isInherited() {
        return this.inherited;
    }

    public boolean hasSubclasses() {
        return this.hasSubclasses;
    }

    public boolean isLazy() {
        return this.lazy;
    }

    public boolean isVersioned() {
        return this.versioned;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public String toString() {
        return "EntityMetamodel(" + this.name + ':' + ArrayHelper.toString(this.properties) + ')';
    }

    public String[] getPropertyNames() {
        return this.propertyNames;
    }

    public Type[] getPropertyTypes() {
        return this.propertyTypes;
    }

    public boolean[] getPropertyLaziness() {
        return this.propertyLaziness;
    }

    public boolean[] getPropertyUpdateability() {
        return this.propertyUpdateability;
    }

    public boolean[] getPropertyCheckability() {
        return this.propertyCheckability;
    }

    public boolean[] getPropertyInsertability() {
        return this.propertyInsertability;
    }

    public boolean[] getPropertyNullability() {
        return this.propertyNullability;
    }

    public boolean[] getPropertyVersionability() {
        return this.propertyVersionability;
    }

    public Cascades.CascadeStyle[] getCascadeStyles() {
        return this.cascadeStyles;
    }
}

