/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.collection.ArrayHolder;
import org.hibernate.collection.CollectionPersister;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.collection.QueryableCollection;
import org.hibernate.engine.Mapping;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.impl.EntityEntry;
import org.hibernate.persister.Joinable;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.type.AbstractType;
import org.hibernate.type.AssociationType;
import org.hibernate.type.ForeignKeyDirection;
import org.hibernate.type.Type;
import org.hibernate.util.ArrayHelper;

public abstract class PersistentCollectionType
extends AbstractType
implements AssociationType {
    private static final Log log = LogFactory.getLog((Class)(class$org$hibernate$type$PersistentCollectionType == null ? (class$org$hibernate$type$PersistentCollectionType = PersistentCollectionType.class$("org.hibernate.type.PersistentCollectionType")) : class$org$hibernate$type$PersistentCollectionType));
    private final String role;
    private final String foreignKeyPropertyName;
    static /* synthetic */ Class class$org$hibernate$type$PersistentCollectionType;

    public PersistentCollectionType(String role, String foreignKeyPropertyName) {
        this.role = role;
        this.foreignKeyPropertyName = foreignKeyPropertyName;
    }

    public String getRole() {
        return this.role;
    }

    public boolean isPersistentCollectionType() {
        return true;
    }

    public final boolean isEqual(Object x, Object y) {
        return x == y || x instanceof PersistentCollection && ((PersistentCollection)x).isWrapper(y) || y instanceof PersistentCollection && ((PersistentCollection)y).isWrapper(x);
    }

    public int compare(Object x, Object y) {
        return 0;
    }

    public int getHashCode(Object x) {
        throw new UnsupportedOperationException("cannot perform lookups on collections");
    }

    public abstract PersistentCollection instantiate(SessionImplementor var1, CollectionPersister var2) throws HibernateException;

    public Object nullSafeGet(ResultSet rs, String name, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        return this.nullSafeGet(rs, new String[]{name}, session, owner);
    }

    public Object nullSafeGet(ResultSet rs, String[] name, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        return this.resolve(null, session, owner);
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index, SessionImplementor session) throws HibernateException, SQLException {
    }

    public int[] sqlTypes(Mapping session) throws MappingException {
        return ArrayHelper.EMPTY_INT_ARRAY;
    }

    public int getColumnSpan(Mapping session) throws MappingException {
        return 0;
    }

    public String toString(Object value, SessionFactoryImplementor factory) throws HibernateException {
        if (value == null) {
            return "null";
        }
        Type elemType = this.getElementType(factory);
        if (Hibernate.isInitialized(value)) {
            ArrayList<String> list = new ArrayList<String>();
            Iterator iter = this.getElementsIterator(value);
            while (iter.hasNext()) {
                list.add(elemType.toString(iter.next(), factory));
            }
            return ((Object)list).toString();
        }
        return "<uninitialized>";
    }

    public Object fromString(String xml) {
        throw new UnsupportedOperationException();
    }

    public Object deepCopy(Object value) throws HibernateException {
        return value;
    }

    public String getName() {
        return this.getReturnedClass().getName();
    }

    public Iterator getElementsIterator(Object collection) {
        return ((Collection)collection).iterator();
    }

    public boolean isMutable() {
        return false;
    }

    public Serializable disassemble(Object value, SessionImplementor session) throws HibernateException {
        return null;
    }

    public Object assemble(Serializable cached, SessionImplementor session, Object owner) throws HibernateException {
        return this.resolve(null, session, owner);
    }

    private boolean isOwnerVersioned(SessionImplementor session) throws MappingException {
        return session.getFactory().getCollectionPersister(this.role).getOwnerEntityPersister().isVersioned();
    }

    public boolean isDirty(Object old, Object current, SessionImplementor session) throws HibernateException {
        return this.isOwnerVersioned(session) && super.isDirty(old, current, session);
    }

    public abstract PersistentCollection wrap(SessionImplementor var1, Object var2);

    public boolean isAssociationType() {
        return true;
    }

    public ForeignKeyDirection getForeignKeyDirection() {
        return ForeignKeyDirection.FOREIGN_KEY_TO_PARENT;
    }

    public Serializable getKeyOfOwner(Object owner, SessionImplementor session) {
        EntityEntry e = session.getEntry(owner);
        if (e == null) {
            return null;
        }
        if (this.foreignKeyPropertyName == null) {
            return e.getId();
        }
        Object id = e.getLoadedValue(this.foreignKeyPropertyName);
        Type keyType = session.getFactory().getCollectionPersister(this.role).getKeyType();
        if (!keyType.getReturnedClass().isInstance(id)) {
            id = (Serializable)keyType.semiResolve(e.getLoadedValue(this.foreignKeyPropertyName), session, owner);
        }
        return (Serializable)id;
    }

    public Object hydrate(ResultSet rs, String[] name, SessionImplementor session, Object owner) {
        return null;
    }

    public Object resolve(Object value, SessionImplementor session, Object owner) throws HibernateException {
        Serializable key = this.getKeyOfOwner(owner, session);
        return key == null ? null : this.getCollection(key, session);
    }

    public Object semiResolve(Object value, SessionImplementor session, Object owner) throws HibernateException {
        throw new UnsupportedOperationException("collection mappings may not form part of a property-ref");
    }

    public boolean isArrayType() {
        return false;
    }

    public boolean useLHSPrimaryKey() {
        return this.foreignKeyPropertyName == null;
    }

    public String getRHSUniqueKeyPropertyName() {
        return null;
    }

    public Joinable getAssociatedJoinable(SessionFactoryImplementor factory) throws MappingException {
        return (Joinable)((Object)factory.getCollectionPersister(this.role));
    }

    public boolean isModified(Object old, Object current, SessionImplementor session) throws HibernateException {
        return false;
    }

    public String getAssociatedEntityName(SessionFactoryImplementor factory) throws MappingException {
        try {
            QueryableCollection collectionPersister = (QueryableCollection)factory.getCollectionPersister(this.role);
            if (!collectionPersister.getElementType().isEntityType()) {
                throw new MappingException("collection was not an association: " + collectionPersister.getRole());
            }
            return collectionPersister.getElementPersister().getEntityName();
        }
        catch (ClassCastException cce) {
            throw new MappingException("collection role is not queryable " + this.role);
        }
    }

    public Object replace(Object original, Object target, SessionImplementor session, Object owner, Map copyCache) throws HibernateException {
        if (original == null) {
            return null;
        }
        if (original == target || !Hibernate.isInitialized(original)) {
            return target;
        }
        Type elemType = this.getElementType(session.getFactory());
        Collection result = (Collection)target;
        result.clear();
        Iterator iter = ((Collection)original).iterator();
        while (iter.hasNext()) {
            result.add(elemType.replace(iter.next(), null, session, owner, copyCache));
        }
        return result;
    }

    public final Type getElementType(SessionFactoryImplementor factory) throws MappingException {
        return factory.getCollectionPersister(this.getRole()).getElementType();
    }

    public String toString() {
        return super.toString() + '(' + this.getRole() + ')';
    }

    public String getOnCondition(String alias, SessionFactoryImplementor factory, Map enabledFilters) throws MappingException {
        return this.getAssociatedJoinable(factory).filterFragment(alias, enabledFilters);
    }

    public Object getCollection(Serializable id, SessionImplementor session) throws HibernateException {
        CollectionPersister persister = session.getFactory().getCollectionPersister(this.role);
        PersistentCollection collection = session.getLoadingCollection(persister, id);
        if (collection != null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("returning loading collection:" + MessageHelper.infoString((CollectionPersister)persister, (Serializable)id)));
            }
        } else {
            if (log.isTraceEnabled()) {
                log.trace((Object)("creating collection wrapper:" + MessageHelper.infoString((CollectionPersister)persister, (Serializable)id)));
            }
            collection = this.instantiate(session, persister);
            session.addUninitializedCollection(collection, persister, id);
            if (persister.isArray()) {
                session.initializeCollection(collection, false);
                session.addArrayHolder((ArrayHolder)collection);
            } else if (!persister.isLazy()) {
                session.addNonLazyCollection(collection);
            }
        }
        return collection.getValue();
    }

    public String getLHSPropertyName() {
        return this.foreignKeyPropertyName;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

