/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.type.LiteralType;
import org.hibernate.type.MutableType;

public class TimeType
extends MutableType
implements LiteralType {
    static /* synthetic */ Class class$0;

    public Object get(ResultSet rs, String name) throws SQLException {
        return rs.getTime(name);
    }

    public Class getReturnedClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.util.Date");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public void set(PreparedStatement st, Object value, int index) throws SQLException {
        Time time = value instanceof Time ? (Time)value : new Time(((Date)value).getTime());
        st.setTime(index, time);
    }

    public int sqlType() {
        return 92;
    }

    public String getName() {
        return "time";
    }

    public String toString(Object val) {
        return new SimpleDateFormat("HH:mm:ss").format((Date)val);
    }

    public boolean isEqual(Object x, Object y) {
        if (x == y) {
            return true;
        }
        if (x == null || y == null) {
            return false;
        }
        Calendar calendar1 = Calendar.getInstance();
        Calendar calendar2 = Calendar.getInstance();
        calendar1.setTime((Date)x);
        calendar2.setTime((Date)y);
        return calendar1.get(11) == calendar2.get(11) && calendar1.get(12) == calendar2.get(12) && calendar1.get(13) == calendar2.get(13) && calendar1.get(14) == calendar2.get(14);
    }

    public int getHashCode(Object x, EntityMode entityMode) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime((Date)x);
        int hashCode = 1;
        hashCode = 31 * hashCode + calendar.get(11);
        hashCode = 31 * hashCode + calendar.get(12);
        hashCode = 31 * hashCode + calendar.get(13);
        hashCode = 31 * hashCode + calendar.get(14);
        return hashCode;
    }

    public Object deepCopyNotNull(Object value) {
        return new Time(((Date)value).getTime());
    }

    public String objectToSQLString(Object value) throws Exception {
        return String.valueOf('\'') + value.toString() + '\'';
    }

    public Object fromStringValue(String xml) throws HibernateException {
        try {
            return new SimpleDateFormat().parse(xml);
        }
        catch (ParseException pe) {
            throw new HibernateException("could not parse XML", pe);
        }
    }
}

