package cours4.test;

import java.util.List;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

import org.hibernate.Session;
import org.hibernate.Transaction;

import cours4.model.Coach;
import cours4.model.Rookie;
import cours4.model.Team;


/**
 * @author Anthony
 *
 * Test inheritance.
 * For the second part of the chapter (ternary + bidirectionnal, 
 * you must rewrite the code yourself
 */
public class InheritanceTest extends TestCaseWithData{

	public void testInheritance() throws Exception  {
		// on suppose que la gestion des exceptions est dsormais
		// gre par vos classes utilitaires et/ou framework
		Session session = openSession();
		Transaction tx=null;
		try {
		  tx = session.beginTransaction();
		  // Teams
		  Team t = new Team("inheritanceTeam");
		  t.addPlayer(new Rookie("inheritancePlayer"));
		  t.setCoach(new Coach("inheritanceCoach"));
		  session.persist(t);
		  tx.commit();
		  session.close();
		  assertNotNull(t.getId());
		  
		  session = openSession();
		  tx = session.beginTransaction();
		  List l = session.createQuery("from Person p").list();
		  assertEquals(2,l.size());
		  tx.commit();
		}
		catch (Exception e) {
		  if (tx!=null) tx.rollback();	
		  throw e;
		}
		finally {
		  session.close();
		}

	}
	


	
	public InheritanceTest(String arg0) {
		super(arg0);
	}
	
	public String[] getMappings() {
		return new String[] {
                "cours4/model/Team.hbm.xml",
                "cours4/model/PersonDiscriminator.hbm.xml",
				//"cours4/model/PersonJoinedSubclass.hbm.xml",
				//"cours4/model/PersonDiscriminatorJoin.hbm.xml",
				// attention pour ce dernier test, l'id doit etre assign manuellement!!!
                //"cours4/model/PersonUnion.hbm.xml",
                "cours4/model/Game.hbm.xml",
                "cours4/model/Sponsor.hbm.xml"};
	}

	public static Test suite() {
		return new TestSuite(InheritanceTest.class);
	}
	
	public static void main(String[] args) throws Exception {
		TestRunner.run( suite() );
	}
}
