package cours5.test;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;

import test.TestCase;
import cours5.model.Characteristic;
import cours5.model.Coach;
import cours5.model.Player;
import cours5.model.School;
import cours5.model.Team;

/**
 * Anthony Patricio
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class HQLTest extends TestCaseWithData {
	public void testLoadTeam() throws Exception  {
	    System.out.println("==========testLoadTeam========");
	    Session session = openSession();
	    Transaction tx=null;
	    try {
	        tx = session.beginTransaction();
	        List results = session.createQuery("select team from Team team").list();
	        //System.out.println(((Player)team.getPlayers().get(0)).getName());
	        tx.commit();
	    }
	    catch (Exception e) {
	        if (tx!=null) tx.rollback();	
	        throw e;
	    }
	    finally {
	        session.close();
	        System.out.println("==========testLoadTeam========");
	    }
	}
    
    public void testSimpleFrom() throws Exception  {
	    System.out.println("==========testSimpleFrom========");
	    init();
	    Session session = openSession();
	    Transaction tx=null;
	    try {
	        tx = session.beginTransaction();
	        StringBuffer queryString = new StringBuffer();
	        queryString.append("select team from Team team ");
	        Query query = session.createQuery(queryString.toString());
	        List results = query.list();
	        tx.commit();
	    }
	    catch (Exception e) {
	        if (tx!=null) tx.rollback();	
	        throw e;
	    }
	    finally {
	        session.close();
	        System.out.println("==========testSimpleFrom========");
	    }
	}
    
    public void testWhereClass() throws Exception  {
	    System.out.println("==========testWhereClass========");
	    init();
	    Session session = openSession();
	    Transaction tx=null;
	    try {
	        tx = session.beginTransaction();
	        StringBuffer queryString = new StringBuffer();
	        queryString.append("from Player p where p.class = Player");
	        Query query = session.createQuery(queryString.toString());
	        List results = query.list();
	        tx.commit();
	    }
	    catch (Exception e) {
	        e.printStackTrace();
	        if (tx!=null) tx.rollback();	
	        throw e;
	    }
	    finally {
	        session.close();
	        System.out.println("==========testWhereClass========");
	    }
	}
    
    public void testSimpleWhere() throws Exception  {
	    System.out.println("==========testSimpleWhere========");
	    init();
	    Session session = openSession();
	    Transaction tx=null;
	    try {
	        tx = session.beginTransaction();
	        StringBuffer queryString = new StringBuffer();
	        queryString.append("select team from Team team where team.name = 'Team A'");
	        Query query = session.createQuery(queryString.toString());
	        List results = query.list();
	        tx.commit();
	    }
	    catch (Exception e) {
	        if (tx!=null) tx.rollback();	
	        throw e;
	    }
	    finally {
	        session.close();
	        System.out.println("==========testSimpleWhere========");
	    }
	}
	
	public void testMultipleSelect() throws Exception  {
	    System.out.println("==========testMultipleSelect========");
	    init();
	    Session session = openSession();
	    Transaction tx=null;
	    try {
	        tx = session.beginTransaction();
	        StringBuffer queryString = new StringBuffer();
	        queryString.append("from Team team, Player player ");
	        Query query = session.createQuery(queryString.toString());
	        List results = query.list();
	        Object[] firstResult = (Object[])results.get(0);
	        Team firstTeam = (Team)firstResult[0];
	        Player firstPlayer = (Player)firstResult[1];
	        tx.commit();
	    }
	    catch (Exception e) {
	        if (tx!=null) tx.rollback();	
	        throw e;
	    }
	    finally {
	        session.close();
	        System.out.println("==========testMultipleSelect========");
	    }
	}
	
	public void testLoadTeamCoachGames() throws Exception  {
	    System.out.println("==========testLoadTeamCoachGames========");
	    init();
	    Session session = openSession();
	    Transaction tx=null;
	    try {
	        tx = session.beginTransaction();
	        StringBuffer queryString = new StringBuffer();
	        queryString.append("select team from Team team ")
	        		.append("left join fetch team.coach c ")
	        		.append("left join fetch team.games g ");
	        Query query = session.createQuery(queryString.toString());
	        List results = query.list();
	        //List results = session.createQuery("select team from Team team join fetch team.coach c join fetch team.games g").list();
	        //System.out.println(((Player)team.getPlayers().get(0)).getName());
	        tx.commit();
	    }
	    catch (Exception e) {
	        if (tx!=null) tx.rollback();	
	        throw e;
	    }
	    finally {
	        session.close();
	        System.out.println("==========testLoadTeamCoachGames========");
	    }
	}
	
	public void testNavigationOnSelect() throws Exception  {
	    System.out.println("==========testNavigationOnSelect========");
	    init();
	    Session session = openSession();
	    Transaction tx=null;
	    try {
	        tx = session.beginTransaction();
	        StringBuffer queryString = new StringBuffer();
	        queryString.append("Select team.coach from Team team");
	        Query query = session.createQuery(queryString.toString());
	        List results = query.list();
	        tx.commit();
	    }
	    catch (Exception e) {
	        if (tx!=null) tx.rollback();	
	        throw e;
	    }
	    finally {
	        session.close();
	        System.out.println("==========testNavigationOnSelect========");
	    }
	}
	
	public void testLoadTeamCoachPlayersSchool() throws Exception  {
	    System.out.println("==========testLoadTeamCoachPlayersSchool========");
	    init();
	    Session session = openSession();
	    Transaction tx=null;
	    try {
	        tx = session.beginTransaction();
	        StringBuffer queryString = new StringBuffer();
	        queryString.append("select team from Team team ")
	        		.append("left join fetch team.coach c ")
	        		.append("left join fetch team.players p ")
	        		.append("left join fetch p.school s");
	        List results = session.createQuery(queryString.toString()).list();
	        //List results = session.createQuery("select team from Team team join fetch team.coach c join fetch team.games g").list();
	        //System.out.println(((Player)team.getPlayers().get(0)).getName());
	        tx.commit();
	    }
	    catch (Exception e) {
	        if (tx!=null) tx.rollback();	
	        throw e;
	    }
	    finally {
	        session.close();
	        System.out.println("==========testLoadTeamCoachPlayersSchool========");
	    }
	}
    
    
    public void testImplicitJoin() throws Exception  {
	    System.out.println("==========testImplicitJoin========");
	    init();
	    Session session = openSession();
	    Transaction tx=null;
	    try {
	        tx = session.beginTransaction();
	        StringBuffer queryString = new StringBuffer();
	        queryString.append("select team from Team team where team.coach.name = 'Team A'");
	        Query query = session.createQuery(queryString.toString());
	        List results = query.list();
	        tx.commit();
	    }
	    catch (Exception e) {
	        if (tx!=null) tx.rollback();	
	        throw e;
	    }
	    finally {
	        session.close();
	        System.out.println("==========testImplicitJoin========");
	    }
	}
    
    public void testWherePositionalParameter() throws Exception  {
	    System.out.println("==========testWherePositionalParameter========");
	    init();
	    Session session = openSession();
	    Transaction tx=null;
	    try {
	        tx = session.beginTransaction();
	        String param = "Team A";
	        StringBuffer queryString = new StringBuffer();
	        queryString.append("select team from Team team where team.name = ?");
	        Query query = session.createQuery(queryString.toString());
	        query.setString(0,param);
	        List results = query.list();
	        tx.commit();
	    }
	    catch (Exception e) {
	        if (tx!=null) tx.rollback();	
	        throw e;
	    }
	    finally {
	        session.close();
	        System.out.println("==========testWherePositionalParameter========");
	    }
	}
    
    
    public void testWhereSetProperties() throws Exception  {
	    System.out.println("==========testWhereSetProperties========");
	    init();
	    Dto dto = new Dto();
	    dto.setPlayerName("pa3");
	    dto.setTeamName("Team A");
	    Session session = openSession();
	    Transaction tx=null;
	    try {
	        tx = session.beginTransaction();
	        StringBuffer queryString = new StringBuffer();
	        queryString.append("select team ")
	        	.append("from Team team ")
	        	.append("join team.players player ")
	        	.append("where team.name = :teamName ")
	        	.append("and player.name = :playerName ");
	        Query query = session.createQuery(queryString.toString());
	        query.setProperties(dto);
	        List results = query.list();
	        tx.commit();
	    }
	    catch (Exception e) {
	        if (tx!=null) tx.rollback();	
	        throw e;
	    }
	    finally {
	        session.close();
	        System.out.println("==========testWhereSetProperties========");
	    }
	}
    
    
    public void testThetaStyle() throws Exception  {
	    System.out.println("==========testThetaStyle========");
	    init();
	    Dto dto = new Dto();
	    dto.setPlayerName("pa3");
	    dto.setTeamName("Team A");
	    Session session = openSession();
	    Transaction tx=null;
	    try {
	        tx = session.beginTransaction();
	        StringBuffer queryString = new StringBuffer();
	        queryString.append("select team ")
	        	.append("from Team team, Player player ")
	        	.append("where team.name = :teamName ")
	        	.append("and player.name = :playerName ")
	        	.append("and player.team.id = team.id ");
	        Query query = session.createQuery(queryString.toString());
	        query.setProperties(dto);
	        List results = query.list();
	        tx.commit();
	    }
	    catch (Exception e) {
	        e.printStackTrace();
	        if (tx!=null) tx.rollback();	
	        throw e;
	    }
	    finally {
	        session.close();
	        System.out.println("==========testThetaStyle========");
	    }
	}
    
    
    
    public void testJoin() throws Exception  {
	    System.out.println("==========testJoin========");
	    init();
	    Dto dto = new Dto();
	    dto.setPlayerName("pa3");
	    dto.setTeamName("Team A");
	    Session session = openSession();
	    Transaction tx=null;
	    try {
	        tx = session.beginTransaction();
	        StringBuffer queryString = new StringBuffer();
	        queryString.append("select team ")
	        	.append("from Team team ")
	        	.append("left join team.coach ")
	        	.append("where team.name = :teamName ");
	        Query query = session.createQuery(queryString.toString());
	        query.setProperties(dto);
	        List results = query.list();
	        tx.commit();
	    }
	    catch (Exception e) {
	        e.printStackTrace();
	        if (tx!=null) tx.rollback();	
	        throw e;
	    }
	    finally {
	        session.close();
	        System.out.println("==========testJoin========");
	    }
	}
    
    
    public void testBatchFetching() throws Exception  {
	    init2();
	    System.out.println("==========testBatchFetching========");
	    Session session = openSession();
	    Transaction tx=null;
	    try {
	        tx = session.beginTransaction();
	        
	        StringBuffer queryString = new StringBuffer();
	        queryString.append("select team from Team team ")
	        		.append("left join fetch team.players p ");
	        Set results = new HashSet(session.createQuery(queryString.toString()).list());
	        
	        Iterator itTeam = results.iterator();
	        while (itTeam.hasNext()){
	            Team team = (Team)itTeam.next();
	            Iterator itPlayer = team.getPlayers().iterator();
		        while (itPlayer.hasNext()){
		            Player player = (Player)itPlayer.next();
		            Iterator itCharacteristic = player.getCharacteristics().iterator();
		            while (itCharacteristic.hasNext()){
		                Characteristic characteristic = (Characteristic)itCharacteristic.next();
		                String test = characteristic.getName();
		            }
		        }
	        }
	        tx.commit();
	    }
	    catch (Exception e) {
	        e.printStackTrace();
	        if (tx!=null) tx.rollback();	
	        throw e;
	    }
	    finally {
	        session.close();
	        System.out.println("==========testBatchFetching========");
	    }
	}
    
	public void testNPlusOneProblem() throws Exception  {
	    init();
	    System.out.println("==========testNPlusOneProblem========");
	    Session session = openSession();
	    Transaction tx=null;
	    try {
	        tx = session.beginTransaction();
	        StringBuffer queryString = new StringBuffer();
	        queryString.append("select team from Team team ")
	        		.append("left join fetch team.coach c ")
	        		.append("left join fetch team.games g ");
	        List results = session.createQuery(queryString.toString()).list();
	        //List results = session.createQuery("select team from Team team join fetch team.coach c join fetch team.games g").list();
	        //System.out.println(((Player)team.getPlayers().get(0)).getName());
	        Team team = (Team)results.get(0);
	        Iterator it = team.getPlayers().iterator();
	        while (it.hasNext()){
	            Player player = (Player)it.next();
	            String test= player.getSchool().getName();
	        }
	        tx.commit();
	    }
	    catch (Exception e) {
	        if (tx!=null) tx.rollback();	
	        throw e;
	    }
	    finally {
	        session.close();
	        System.out.println("==========testNPlusOneProblem========");
	    }
	}
	
	public void testElementsOnSelect() throws Exception  {
	    System.out.println("==========testElementsOnSelect========");
	    init();
	    Session session = openSession();
	    Transaction tx=null;
	    try {
	        tx = session.beginTransaction();
	        StringBuffer queryString = new StringBuffer();
	        queryString.append("Select elements(team.players) from Team team");
	        Query query = session.createQuery(queryString.toString());
	        List results = query.list();
	        tx.commit();
	    }
	    catch (Exception e) {
	        if (tx!=null) tx.rollback();	
	        throw e;
	    }
	    finally {
	        session.close();
	        System.out.println("==========testElementsOnSelect========");
	    }
	}
	
	public void testPagingHQL() throws Exception  {
	    System.out.println("==========testPagingHQL========");
	    init();
	    Session session = openSession();
	    Transaction tx=null;
	    try {
	        tx = session.beginTransaction();
	    	Query query = session.createQuery("from Team team");
	    	query.setFirstResult(10)
	    		.setMaxResults(20);
	        List result = query.list();
	    	tx.commit();
	    }
	    catch (Exception e) {
	        if (tx!=null) tx.rollback();	
	        throw e;
	    }
	    finally {
	        session.close();
	        System.out.println("==========testPagingHQL========");
	    }
	}
	
	public void testHQLBetween() throws Exception  {
	    System.out.println("==========testHQLBetween========");
	    init();
	    Session session = openSession();
	    Transaction tx=null;
	    try {
	        tx = session.beginTransaction();
	        StringBuffer queryString = new StringBuffer();
	        queryString.append("Select player from Player player ")
	        	.append("where player.height between 1.80 and 1.90 ");
	        Query query = session.createQuery(queryString.toString());
	        List result = query.list();
	    	tx.commit();
	    }
	    catch (Exception e) {
	        if (tx!=null) tx.rollback();	
	        throw e;
	    }
	    finally {
	        session.close();
	        System.out.println("==========testHQLBetween========");
	    }
	}
	
	public void testHQLIn() throws Exception  {
	    System.out.println("==========testHQLIn========");
	    init();
	    Session session = openSession();
	    Transaction tx=null;
	    try {
	        tx = session.beginTransaction();
	        StringBuffer queryString = new StringBuffer();
	        queryString.append("Select player from Player player ")
	        	.append("where player.name in ('pa1','pa6')");
	        Query query = session.createQuery(queryString.toString());
	        List result = query.list();
	    	tx.commit();
	    }
	    catch (Exception e) {
	        if (tx!=null) tx.rollback();	
	        throw e;
	    }
	    finally {
	        session.close();
	        System.out.println("==========testHQLIn========");
	    }
	}
	
	public void testHQLInSetCollection() throws Exception  {
	    System.out.println("==========testHQLInSetCollection========");
	    init();
	    Session session = openSession();
	    Transaction tx=null;
	    try {
	        List nameList = new ArrayList();
	        nameList.add("pa1");
	        nameList.add("pa6");
	        tx = session.beginTransaction();
	        StringBuffer queryString = new StringBuffer();
	        queryString.append("Select player from Player player ")
	        	.append("where player.name in (:nameList)");
	        Query query = session.createQuery(queryString.toString());
	        query.setParameterList("nameList",nameList);
	        List result = query.list();
	    	tx.commit();
	    }
	    catch (Exception e) {
	        e.printStackTrace();
	        if (tx!=null) tx.rollback();	
	        throw e;
	    }
	    finally {
	        session.close();
	        System.out.println("==========testHQLInSetCollection========");
	    }
	}
	
	public void testHQLSelectNew() throws Exception  {
	    System.out.println("==========testHQLSelectNew========");
	    init();
	    Session session = openSession();
	    Transaction tx=null;
	    try {
	        List nameList = new ArrayList();
	        nameList.add("pa1");
	        nameList.add("pa6");
	        tx = session.beginTransaction();
	        StringBuffer queryString = new StringBuffer();
	        queryString.append("Select new DTO(player.name, player.height) from Player player ");
	        Query query = session.createQuery(queryString.toString());
	        List result = query.list();
	    	tx.commit();
	    }
	    catch (Exception e) {
	        e.printStackTrace();
	        if (tx!=null) tx.rollback();	
	        throw e;
	    }
	    finally {
	        session.close();
	        System.out.println("==========testHQLSelectNew========");
	    }
	}
	
	public void testHQLAvg() throws Exception  {
	    System.out.println("==========testHQLSelectNew========");
	    init();
	    Session session = openSession();
	    Transaction tx=null;
	    try {
	        tx = session.beginTransaction();
	        StringBuffer queryString = new StringBuffer();
	        queryString.append("Select avg(player.height) ")
	        	.append("from Team team join team.players player ")
	        	.append("group by team ")
	        	.append("having count(player) >5");
	        Query query = session.createQuery(queryString.toString());
	        List result = query.list();
	    	tx.commit();
	    }
	    catch (Exception e) {
	        e.printStackTrace();
	        if (tx!=null) tx.rollback();	
	        throw e;
	    }
	    finally {
	        session.close();
	        System.out.println("==========testHQLSelectNew========");
	    }
	}
	
	public void testSubSelect() throws Exception  {
	    System.out.println("==========testSubSelect========");
	    init();
	    Session session = openSession();
	    Transaction tx=null;
	    try {
	        tx = session.beginTransaction();
	        StringBuffer queryString = new StringBuffer();
	        queryString.append("from Team team ")
	        	.append("where 1 = ")
	        	.append(" (select max(player.height) from team.players player)");
	        Query query = session.createQuery(queryString.toString());
	        List result = query.list();
	    	tx.commit();
	    }
	    catch (Exception e) {
	        e.printStackTrace();
	        if (tx!=null) tx.rollback();	
	        throw e;
	    }
	    finally {
	        session.close();
	        System.out.println("==========testSubSelect========");
	    }
	}
    
	public String[] getMappings() {
		return new String[] {"cours5/model/Team.hbm.xml",
				"cours5/model/Coach.hbm.xml",
				"cours5/model/Player.hbm.xml",
				"cours5/model/Characteristic.hbm.xml",
				"cours5/model/School.hbm.xml",
				"cours5/model/Game.hbm.xml" };
	}    
    
    
    
    public HQLTest(String x) {
		super(x);
	}

	public static Test suite() {
		return new TestSuite(HQLTest.class);
	}

	public static void main(String[] args) throws Exception {
		TestRunner.run( suite() );
	}
}
