var gSource;
var gRdfElement;
/* pour charger la source de donnes RDF */
function chargerSourceRDF(pId) {
	try {
		gRdfElement = document.getElementById(pId);
		var rdfService = Components.classes["@mozilla.org/rdf/rdf-service;1"].getService(Components.interfaces.nsIRDFService);
		(gSource != null) ? gRdfElement.database.RemoveDataSource(gSource) : null; //pour quand on change de source
		gSource = rdfService.GetDataSource("http://"+gConfig.php.hote+gConfig.php.cheminrdf+"?derniereVisite="+gDerniereVisite);
		dump("Chargement de http://"+gConfig.php.hote+gConfig.php.cheminrdf+"?derniereVisite="+gDerniereVisite+"\n");
		gSource.QueryInterface(Components.interfaces.nsIRDFRemoteDataSource);
		gSource.QueryInterface(Components.interfaces.nsIRDFXMLSink);
		gSource.addXMLSinkObserver(gObserveur);
		gRdfElement.database.AddDataSource(gSource);
		if (gSource.loaded) {
			gRdfElement.builder.rebuild();
			dump("Source charge, reconstruction immdiate\n");
		}
		dump("Source reconstruite : "+gConfig.php.hote+gConfig.php.cheminrdf+"?derniereVisite="+gDerniereVisite+"\n");
		mettreAJourSourceRDF();
	} catch (e) {
		ajouterErreur(gStringBundle.getFormattedString("erreurChargementRdf", new Array(e+"", gSource.toString())));
		dump(e+"\n");
	}
}

var gObserveur = {
	onBeginLoad : function (pSink) {
		document.getElementById("xf-statusbar-progres").setAttribute("mode", "undetermined");
		},
	onInterrupt : function (pSink) { },
	onResume : function (pSink) { },
	onError : function (pSink, pStatut, pErreur) {
		ajouterErreur(
			gStringBundle.getFormattedString("erreurChargementRdfAsync", new Array(pErreur, pStatut))); },
	onEndLoad : function (pSink) {
		document.getElementById("xf-statusbar-progres").setAttribute("mode", "determined");
		ajouterErreur(gStringBundle.getString("chargementTermine"));
		gRdfElement.builder.rebuild();
	}
}

/* appele rgulirement et en cas de bouton recharger */
function mettreAJourSourceRDF() {
	try {
		document.getElementById("xf-statusbar-progres").setAttribute("mode", "undetermined");
		gSource.Refresh(false);
	} catch (e) {
		document.getElementById("xf-statusbar-progres").setAttribute("mode", "determined");
		ajouterErreur(gStringBundle.getFormattedString("erreurChargementRdf", new Array(e+"", gSource.toString())));
		dump(e+"\n");
	}
}

/* appele en tout dbut de script dans initialisation()
   on aura en plus de a des appels aprs la mise  jour
   d'une source */
const RDFDELAI = 60000; //mise  jour RDF toutes les minutes
function minuteurRDF() {
	mettreAJourSourceRDF();
	setTimeout(minuteurRDF, RDFDELAI);
}
