var gPhpSessName;
var gPhpSessId;
var gAuteur;

function initialiserSoap(pAuteur, pPhpSessName, pPhpSessId) {
	/* + soit on est dj  index.xul et on a une session de fournie
	auquel cas, on l'utilise, et on vrifie qu'elle est toujours bonne
	   + soit on est sur xulforum.xul, et on n'a pas de session : il faut
	donc en obtenir une */
	netscape.security.PrivilegeManager.enablePrivilege("UniversalBrowserRead");

	gAuteur = pAuteur;
	if (arguments.length == 3) {
		gPhpSessName = pPhpSessName;
		gPhpSessId = pPhpSessId;
		verifierSessionSoap();
	} else {
		var r = verifierSessionSoap();
		gPhpSessName = r[0];
		gPhpSessId = r[1];
	}
}

function _transportUri() {
	//dump(gConfig);
	return 'http://'+gConfig.php.hote+gConfig.php.chemin+'soap.php?'+gPhpSessName+"="+gPhpSessId;
	//return 'http://localhost/~jonathan/xulforum/soap.php?'+gPhpSessName+"="+gPhpSessId;
}

function _appelSoap(methode, parametres) {
	document.getElementById("xf-statusbar-progres").setAttribute("mode", "undetermined");
	var appel = new SOAPCall();
	appel.transportURI = _transportUri();
	var p = new Array();
	var i = 0;
	for (a in parametres)
		p[i++] = new SOAPParameter(parametres[a], a);
	appel.encode(0, methode, "http://www.xulforum.org/xfServeur", 0, null, p.length, p);
	var r = appel.invoke();

	document.getElementById("xf-statusbar-progres").setAttribute("mode", "determined");
	if (r.fault) { //nsISoapFault
		dump("Erreur SOAP : "+r.fault.faultCode+" ; "+r.fault.faultString+"\n");
		ajouterErreur(gStringBundle.getFormattedString("erreurSoap", new Array(String(r.fault.faultCode), String(r.fault.faultString))));
		return false;
	} else {
		return r.getParameters(false, {});
	}
}

function verifierSessionSoap() { //il faut vrifier la valeur de retour
	/* il faut comparer notre session (variable gPhpSess...)
	   et celle rendue par le serveur. Si le serveur en rend une
	   diffrente, c'est que notre session a expire donc cette
	   fonction met  jour les variables gPhpSess si on nous fournit
	   une nouvelle session. Elle retourne les paramtres de l'appel serveur
	   [phpsessname, phpsessid, identok]. Il n'y a rien  voir
	   avec une identification ok ou non, c'est juste un pb de session
	   NB : Mozilla semble garder le cookie mais on n'est jamais
	   trop prudent */
	var retour = _appelSoap("infosSession", {});
	if (!retour) return false;
	var valeurs = String(retour[0].value).split(",");

	if (valeurs[1] != gPhpSessId) {
		gPhpSessName = valeurs[0];
		gPhpSessId = valeurs[1];
	}

	valeurs[2] = Number(valeurs[2]); //oui, "0" est VRAI car pas chane vide
	return valeurs;
}

function identifierSoap(pUtilisateur, pPass) {
	/* cette fonction concerne uniquement l'identification
	+ si on a des paramtres fournis, on appelle le serveur avec
	+ si on n'a pas de paramtres fournis, on appelle le serveur sans
	==> dans tous les cas, le serveur voit si il a besoin de revrifier
		avec ldap la validit des infos 
		
	+ si l'ident a russi, return;
	+ si l'ident a foir, on lance une bote de dialogue avec prompt()
	  qui demande user:pass@host ou rien pour annuler et retourner  
	  l'cran d'identification
	*/
	var retour = _appelSoap("identification", { "param0" : pUtilisateur, "param1" : pPass });
	if (!retour) return false;
	var valeur = Number(retour[0].value);

	if (valeur == 1) {
		dump("Identification russie pour "+pUtilisateur+"/"+pPass+"\n");
		return true;
	} else {
		ajouterErreur(gStringBundle.getString("identificationEchec"));
		return false;
	}
}

function obtenirMessageSoap(pUri) {
	/* la fonction vrifie juste si la session est la bonne 
	   et appelle le serveur. Pas besoin d'identification */
	if (!verifierSessionSoap())
		return false;

	var r = _appelSoap("obtenirMessage", { "param1" : pUri });
	if (!r)
		return false;

	/* code pour si jamais php retourne un tableau associatif... marche pas (juste la date) */
	/*var e  = r[0].value.enumerator; //.getNext().value.enumerator;
	var e1;
	while (e.hasMoreElements()) {
		e1 = e.getNext().value;
		dump(e1);
	}*/

	dump(r[0].value+"\n");
	var o =  r[0].value.slice(","); //on peut slicer sur la virgule parce qu'on la remplace par &#44;
	return {
		"titre" : o[0],
		"texte" : o[1],
		"auteur" : o[2],
		"date" : o[3]
	};
}

function posterMessageSoap(pTitre, pTexte, pSId) {
	/* l on doit verifierSessionSoap()[2]
	   + si true, on passe  la suite
	   + si false, on arrte l, msg d'erreur, etc.
	*/
	var v = verifierSessionSoap();
	if (!v) {
		ajouterErreur(gStringBundle.GetString("pasIdentifie"));
		return false;
	}
	if (!v[2]) {
		ajouterErreur(gStringBundle.GetString("pasIdentifie"));
		return false;
	}
	var r = _appelSoap("enregistrerMessage", {
		"param0" : pTitre,
		"param1" : pTexte,
		"param2" : gAuteur,
		"param3" : null,
		"param4" : pSId
	});
	if (r == false)
		return false;
	else
		return true;
}

/*
//tests unitaires
initialiserSoap("jonathan");
dump(identifierSoap("uid=jonathan,ou=utilisateurs,o=xulforum", "cazala")+"\n");
//var r = verifierSessionSoap();
//if (r)
//	dump(gPhpSessName+"="+gPhpSessId+"  "+r[2]+"\n");
//obtenirMessageSoap("http://www.xulforum.org/sujets/2/messages/3/");
posterMessageSoap("Titre d'un message super sympatoche", "Un texte toujours qui tue ^^", "http://www.xulforum.org/sujets/1/");
*/
