<?php
error_reporting(E_STRICT);
include("./global.inc.php");

class xfMessage {
	function __construct($titre, $texte, $auteur, $date) {
		$this->titre = $titre;
		$this->auteur = $auteur;
		$this->date = $date;
		$this->texte = $texte;
	}

	function __toString() {
		return "$titre,$texte,$auteur,$date";
	}
}

class xfServeur {

	private $dejaVu = 0;
	private $db;
	private $identOk = 0;
	private $ldapHost, $mysqlHost, $mysqlUser, $mysqlPass;

	function __construct($pLdapHost, $pMysqlHost, $pMysqlUser, $pMysqlPass) {
		/* initialisation de tout ce qui concerne les sessions */
		session_start();

		/* pour mysql */
		$this->mysqlHost = $pMysqlHost;
		$this->mysqlUser = $pMysqlUser;
		$this->mysqlPass = $pMysqlPass;

		/* pour ldap */
		$this->ldapHost = $pLdapHost;
	}

	private function _connecterMySQL() {
		if ($this->db != null) return;
		$this->db = @mysql_connect($this->mysqlHost, $this->mysqlUser, $this->mysqlPass);
		if (!$this->db)
			throw new SOAPFault("SOAP:Server/SQL", "Impossible de se connecter à la base de données");
		$r = @mysql_query("USE jonathan", $this->db);
		if (!$r)
			throw new SOAPFault("SOAP:Server/SQL", mysql_error($this->db));
	}

	public function identification($pNom, $pPass) {
		file_put_contents("/dev/tty11", "Déjà vu ? {$this->dejaVu} Ident ? {$this->identOk}");
		file_put_contents("/dev/tty11", "Tentative d'identification LDAP sur {$this->ldapHost} avec $pNom & $pPass\n");
		$pNom = html_entity_decode($pNom);
		if ($pNom == null && $pPass == null) return 0;
		if ($this->dejaVu && $this->identOk) {
			return 1;
		} else {
			/* LDAP */
			$l = @ldap_connect($this->ldapHost);
			if (!$l)
				throw new SoapFault("SOAP:Server", "Impossible de se connecter à LDAP");
			@ldap_set_option($l, LDAP_OPT_PROTOCOL_VERSION, 3);
			$b = @ldap_bind($l, $pNom, $pPass);
			file_put_contents("/dev/tty11", "Le bind a donné : $b\n");
			ldap_close($l);
			/* FIN */

			if ($b) {
				$this->identOk = 1;
				$this->dejaVu = 1;
				return 1;
			} else {
				$this->identOk = 0;
				$this->dejaVu = 1;
				return 0;
			}
		}
	}

	public function infosSession() {
		return array(session_name(), session_id(), $this->identOk);
	}

	public function obtenirMessage($pMsg) {
		$parties =  explode("/", $pMsg);
		if (count($parties) == 5 || count($parties) == 6)  { //pour prendre en compte le / final
			$sId = $parties[4];
			$sujet = $this->_chercherSujet($sId);
			return $sujet;
		} else if (count($parties) == 7 || count($parties) == 8) {
			$sId = $parties[4];
			$mId = $parties[6];
			$message = $this->_chercherMessage($sId, $mId);
			return $message;
		} else {
			throw new SOAPFault("SOAP:Serveur", "URI de message ou sujet demandé inconnue");
		}
	}

	private function _chercherSujet($sId) {
		$this->_connecterMySQL();
		$r = @mysql_query("SELECT titre,auteur,date FROM xf_sujets WHERE id='$sId'", $this->db);
		if (!$r)
			throw new SOAPFault("SOAP:Server/SQL", mysql_error($this->db));
		//return $this->_toutEnUnicode(@mysql_fetch_array($r));
		$v =  $this->_toutEnUnicode(@mysql_fetch_array($r));
		return new SOAPVar(new xfMessage($v->titre, null, $v->auteur, $v->date));
	}

	private function _toutEnUnicode($o) {
		foreach ($o as $p => $v) {
			$o[$p] = utf8_encode($v);
			file_put_contents("/dev/tty11", $p);
		}
		return $o;
	}

	private function _chercherMessage($sId, $mId) {
		$this->_connecterMySQL();
		$r = @mysql_query("SELECT titre,auteur,date FROM xf_messages WHERE s_id='$sId' AND id='$mId'", $this->db);
		if (!$r)
			throw new SOAPFault("SOAP:Server/SQL", mysql_error($this->db));
		//return $this->_toutEnUnicode(@mysql_fetch_row($r));
		$v =  $this->_toutEnUnicode(@mysql_fetch_array($r));
		return new SOAPParam(new SOAPVar(new xfMessage($v->titre, $v->texte, $v->auteur, $v->date), XSD_STRING), "param1");
	}

}

$s = new SOAPServer(null, array('uri' => 'http://www.xulforum.org/xfServeur'));
$s->setClass("xfServeur", $ldapHost, $mysqlHost, $mysqlUser, $mysqlPass);
$s->setPersistence(SOAP_PERSISTENCE_SESSION);

if ($_SERVER['REQUEST_METHOD'] == "POST") {
	$s->handle();
} else {
	header("Content-type: text/plain");
	echo "Fonctions supportées par ce serveur SOAP : \n";
	foreach($s->getFunctions() as $f)
		echo $f."\n";
}
?>
