<?php
error_reporting(E_STRICT);
include("./global.inc.php");

class xfServeur {

	private $dejaVu = 0;
	private $db;
	private $identOk = false;
	private $ldapHost, $mysqlHost, $mysqlUser, $mysqlPass;
	private $debug = 0;

	function __construct($pLdapHost, $pMysqlHost, $pMysqlUser, $pMysqlPass) {
		/* initialisation de tout ce qui concerne les sessions */
		session_start();
		$this->identOk = false;

		/* pour mysql */
		$this->mysqlHost = $pMysqlHost;
		$this->mysqlUser = $pMysqlUser;
		$this->mysqlPass = $pMysqlPass;

		/* pour ldap */
		$this->ldapHost = $pLdapHost;
	}

	public function identification($pNom, $pPass) {
		/* $this->identOk = 1; //FIXME
		return true; //FIXME */
		file_put_contents("/dev/tty11", "Déjà vu ? {$this->dejaVu} Ident ? {$this->identOk}");
		file_put_contents("/dev/tty11", "Tentative d'identification LDAP sur {$this->ldapHost} avec $pNom & $pPass\n");
		$pNom = html_entity_decode($pNom);
		if ($pNom == null && $pPass == null) return 0;
		if ($this->dejaVu && $this->identOk) {
			return 1;
		} else {
			/* LDAP */
			$l = @ldap_connect($this->ldapHost);
			if (!$l)
				throw new SoapFault("SOAP:Server", "Impossible de se connecter à LDAP");
			@ldap_set_option($l, LDAP_OPT_PROTOCOL_VERSION, 3);
			$b = @ldap_bind($l, $pNom, $pPass);
			file_put_contents("/dev/tty11", "Le bind a donné : $b\n");
			ldap_close($l);
			/* FIN */

			if ($b) {
				$this->identOk = true;
				$this->dejaVu = 1;
				return 1;
			} else {
				$this->identOk = false;
				$this->dejaVu = 1;
				return 0;
			}
		}
	}

	public function infosSession() {
		$this->debug++;
		file_put_contents("/dev/tty11", "\ndebug : {$this->debug}\n");
		return array(session_name(), session_id(), (int)$this->identOk);
	}

	public function obtenirMessage($pMsg) {
		file_put_contents("/dev/tty11", "\nMessage $pMsg demandé\n");
		$parties =  explode("/", $pMsg);
		if (count($parties) == 4 || count($parties) == 5)  { //pour prendre en compte le / final
			$sId = $parties[4];
			$sujet = $this->_chercherSujet($sId);
			return $sujet;
		} else if (count($parties) == 6 || count($parties) == 7) {
			$sId = $parties[4];
			$mId = $parties[6];
			$message = $this->_chercherMessage($sId, $mId);
			return $message;
		} else {
			throw new SOAPFault("SOAP:Serveur", "URI de message ou sujet demandé inconnue");
		}
	}

	public function enregistrerMessage($titre, $texte, $auteur, $date, $sId) {
		if (!$this->identOk)
			throw new SOAPFault("SOAP-ENV:Server", "Pas identifié, veuillez réessayer !");
		$texte = strip_tags($texte, "<b> <u> <i> <a> <ul> <li> <ol>");
		$this->_connecterMySQL();
		$titre = addslashes(utf8_decode($titre));
		$texte = addslashes(utf8_decode($texte));
		$texte = nl2br($texte);
		$auteur = addslashes(utf8_decode($auteur));
		if (!$sId) {
			$r = @mysql_query("INSERT INTO xf_sujets(titre, texte, auteur, date) VALUES('$titre', '$texte', '$auteur', NOW())");
			if (!$r)
				throw new SOAPFault("Server:SQL", mysql_error());
		} else {
			$parties = explode("/", $sId);
			$sId = $parties[4];
			$r = @mysql_query("INSERT INTO xf_messages(s_id, titre, texte, auteur, date) VALUES('$sId', '$titre', '$texte', '$auteur', NOW())");
			if (!$r)
				throw new SOAPFault("Server:SQL", mysql_error());
		}
	}

	private function _connecterMySQL() {
		if ($this->db != null) return;
		$this->db = @mysql_connect($this->mysqlHost, $this->mysqlUser, $this->mysqlPass);
		if (!$this->db)
			throw new SOAPFault("SOAP:Server/SQL", "Impossible de se connecter à la base de données");
		$r = @mysql_query("USE jonathan", $this->db);
		if (!$r)
			throw new SOAPFault("SOAP:Server/SQL", mysql_error($this->db));
	}

	private function _toutEnUnicode($o) {
		foreach ($o as $p => $v) {
			$o[$p] = utf8_encode($v);
		}
		return $o;
	}

	private function _chercherSujet($sId) {
		$this->_connecterMySQL();
		$r = @mysql_query("SELECT titre,texte,auteur,date FROM xf_sujets WHERE id='$sId'", $this->db);
		if (!$r)
			throw new SOAPFault("SOAP:Server/SQL", mysql_error($this->db));
		return $this->_toutEnUnicode(@mysql_fetch_row($r));
	}

	private function _chercherMessage($sId, $mId) {
		$this->_connecterMySQL();
		$r = @mysql_query("SELECT titre,texte,auteur,date FROM xf_messages WHERE s_id='$sId' AND id='$mId'", $this->db);
		if (!$r)
			throw new SOAPFault("SOAP:Server/SQL", mysql_error($this->db));
		return $this->_toutEnUnicode(@mysql_fetch_row($r));
	}

}

//$s = new SOAPServer("./xfServeur.wsdl");
$s = new SOAPServer(null, array("uri" => "http://www.xulforum.org/xfServeur"));
$s->setClass("xfServeur", $ldapHost, $mysqlHost, $mysqlUser, $mysqlPass);
$s->setPersistence(SOAP_PERSISTENCE_SESSION);

if ($_SERVER['REQUEST_METHOD'] == "POST") {
	$s->handle();
} else {
	header("Content-type: text/plain");
	echo "Fonctions supportées par ce serveur SOAP : \n";
	foreach($s->getFunctions() as $f)
		echo $f."\n";
}
?>
