/* inclusion */
var jComposant =  Components.classes["@mozilla.org/moz/jssubscript-loader;1"]
    .createInstance();
var jInterface = jComposant.QueryInterface(Components.interfaces.mozIJSSubScriptLoader);
jInterface.loadSubScript("chrome://xulforum/content/javascript/global.js");
jInterface.loadSubScript("chrome://xulforum/content/javascript/config.js");
jInterface.loadSubScript("chrome://xulforum/content/javascript/rdf.js");
jInterface.loadSubScript("chrome://xulforum/content/javascript/prefs.js");
jInterface.loadSubScript("chrome://xulforum/content/javascript/ldap.js");
jInterface.loadSubScript("chrome://xulforum/content/javascript/soap.js");

var gDerniereVisite = 0;
var gPrefs = null;

/* initialisation */
function initialisation() {
	/* pour le double-clic qui ouvre un popup */
	document.getElementById("xf-index-arbre").
		addEventListener("dblclick", ouvrirPopupSujet, true);

	/* extraction des composants de l'url sous la forme
	config=XX&phpsessname=XX&phpsessid=XX&auteur=XX pas prvu pour changer
	le sparateur est & et non pas &amp; (pas de conformit xhtml) */
	var l = decodeURI(document.location.href);
	dump(l+"\n");
	var vars = l.split("&");
	var phpSessName = vars[1].substr(vars[1].indexOf("=")+1);
	var phpSessId = vars[2].substr(vars[2].indexOf("=")+1);
	var auteur = vars[3].substr(vars[3].indexOf("=")+1);
	dump("Session: nom / id :"+phpSessName+" / "+phpSessId+"\n");

	/* sert  rcuprer la dernire visite */
	var c = vars[0].substr(vars[0].indexOf("=")+1);
	dump("\n\n\n"+c+"\n\n\n");

	var o = new Object;
	o["derniereVisite."+c] = 0;
	var p = chargerPrefs(o);
	gDerniereVisite = p["derniereVisite."+c];
	gPrefs = p;
	dump("** Connect en tant que : "+p["dernierUtilisateur"]+"\n");

	/* sert  charger les paramtres */
	chargerParametres(c);
	chargerSourceRDF("xf-index-arbre");
	minuteurRDF();

	/* l'arbre est rempli mais il faut aussi remplir la liste
	des utilisateurs, on utilise donc LDAP pour remplir tout a */
	chargerSourceLDAP();

	/* soap doit s'initialiser aprs la config ! */
	initialiserSoap(auteur, phpSessName, phpSessId);

	/* l maintenant on peut dire que la nouvelle dernire visite
		est maintenant */
	o = new Object;
	var d = new Date;
	//o["derniereVisite."+gConfig.url] = d.getTime()/1000;
	/* RQ : a c'est la thorie ; en pratique le serveur
	et le client sont jamais synchro niveau heure
	d'o pb avec les sujets lus/non lus
	==> on rcupre l'heure du serveur mysql via une page
	php et en plus pas de pb de dcalage horaire :) */
	try {
		var x = new XMLHttpRequest;
		x.open("GET", "http://"+gConfig.php.hote+gConfig.php.chemin+"time.php", false);
		dump("http://"+gConfig.php.hote+gConfig.php.chemin+"time.php\n");
		x.send(null);
		if (x.status == 200)
			o["derniereVisite."+gConfig.url] = Number(x.responseText);
		else
			o["derniereVisite."+gConfig.url] = d.getTime()/1000;
		dump("Heure serveur : "+x.responseText+"\n");
	} catch (e) {
		dump("Timestamp local retenu \n");
		o["derniereVisite."+gConfig.url] = d.getTime()/1000;
		dump(e+"\n");
	}

	enregistrerPrefs(o);
}

/* pour remplir la liste des utilisateurs */
function chargerSourceLDAP() {
	gLdapFonctions.apresRecherche = remplirListeMembres;
	var dn = gConfig.ldap.baseDn;
	var hote = gConfig.ldap.hote;
	dump("\n\nLancement remplissage LDAP\n");
	initialiserLDAP(dn, hote);
}

/* remplit les attributs d'un utilisateur en particulier
c'est le retour sur la recherche sur LE membre plus bas */
function remplirPanneauInfosMembre(pAttributs) {
	dump("Remplissage infos\n");
	document.getElementById("xf-index-membres-avatar")
		.src = "data:image/jpeg;base64,"+pAttributs["jpegPhoto"];
	document.getElementById("xf-index-membres-localisation").value = pAttributs["l"];
	document.getElementById("xf-index-membres-email").value = pAttributs.mail;
	document.getElementById("xf-index-membres-description").value = pAttributs.description;
	document.getElementById("xf-index-membres-nom").value = pAttributs.cn;
}

/* callback lorsqu'on clique sur un utilisateur dans la liste : on lance
une recherche ldap sur les attributs de cet utilisateur en particulier */
function remplirInfosMembre(pMembre) {
	dump("Membre slectionn : "+pMembre+"\n");
	gLdapFonctions.apresRecherche = remplirPanneauInfosMembre;
	var dn = "uid="+pMembre+","+gConfig.ldap.baseDn;
	var hote = gConfig.ldap.hote;
	initialiserLDAP(dn, hote);
}

/* utilise avec une recherche sur toute l'organisational unit des utilisateurs : pour chaque entre, la fonction ajoute un listitem  la listbox */
function remplirListeMembres(pAttributs) {
	if (pAttributs["cn"] == null)
		return;
	var l = document.getElementById("xf-index-membres-liste");
	var li = document.createElement("listitem");
	li.setAttribute("label", pAttributs["cn"]);
	li.setAttribute("class", "listitem-iconic");
	li.setAttribute("style", "list-style-image: url(\"chrome://xulforum/skin/stock_person.png\")");
	li.setAttribute("onclick", "remplirInfosMembre('"+pAttributs["uid"]+"')");
	l.appendChild(li);

	var count = 0;
	var ret = new Object;
	//dump(pAttributs["b_jpegPhoto"].get(count, ret));
}

/* callback lorsqu'on double-clique sur le tree */
function ouvrirPopupSujet(e) {
	var t = document.getElementById("xf-index-arbre");
	if (t.view.selection.count != 1)
		return;
	var index = t.currentIndex;
	var col = t.columns["xf-index-arbre-id"];
	var titre = e.currentTarget.view.getCellText(index, col)+"\n"; 

	var divs = document.getElementById("xf-div-popups").childNodes;
	var trouve = false;
	var i;
	for (i = 0; i < divs.length; ++i) { /* on cherche si on a dj utilis un div pour ce sujet */
		if (divs[i].nodeName[0] != "#" && divs[i].id == titre) {
			trouve = true;
			dump(divs[i].id+"\n");
			divs[i].deplier();
			dump(divs[i].nodeName);
			break;
		}
	}
	if (!trouve) { /* si on n'en a pas trouv, on prend le premier qui est libre (il est aussi libre si il est cach) */
		for (i = 0; i < divs.length; ++i) {
			if (divs[i].nodeName[0] != "#" && (divs[i].id == "" || divs[i].style.visibility == "hidden")) {
				trouve = true;
				break;
			}
		}
	}
	if (!trouve)
		ajouterErreur(gStringBundle.getString("tropSujetsOuverts"));

	var message = obtenirMessageSoap(titre);
	var mDate = message["date"].substr(8, 2);
	var mMonth = message["date"].substr(5, 2);
	var mYear = message["date"].substr(2, 2);
	var mHours = message["date"].substr(11, 2);
	var mMinutes = message["date"].substr(14, 2);

	var div = divs[i];
	div.id  = titre;
	div.setAttribute("sId", titre);
	div.setAttribute("auteur", message["auteur"]);
	div.setAttribute("date", mDate+"/"+mMonth+"/"+mYear+" "+mHours+":"+mMinutes);
	div.setAttribute("titre", message["titre"]);

	var p = div.getElementsByTagName("p")[0];
	p.innerHTML = message["texte"];

	div.style.visibility = "visible";
	div.deplier();
}

/* les callbacks pour les commandes de la toolbar */
function plierSujets() {
	var s = document.getElementsByTagName("div");
	for (var i=0; i < s.length; i++) {
		if (s[i].className == "fenetreMsg" && s[i].style.visibility == "visible")
			s[i].plier();
	}
}

function deplierSujets() {
	var s = document.getElementsByTagName("div");
	for (var i=0; i < s.length; i++) {
		if (s[i].className == "fenetreMsg" && s[i].style.visibility == "visible")
			s[i].deplier();
	}
}

function cacherSujets() {
	var s = document.getElementsByTagName("div");
	for (var i=0; i < s.length; i++) {
		if (s[i].className == "fenetreMsg" && s[i].style.visibility == "visible")
			s[i].cacher();
	}
}
