<?php
header("Content-type: text/xml");

$d = new DOMDocument('1.0', 'utf-8');
$r = $d->createElementNS("http://www.w3.org/1999/02/22-rdf-syntax-ns#",
    "RDF:RDF");
$r->setAttribute("xmlns:XF", "http://www.xulforum.fr/rdf#");
$d->appendChild($r);

try {
	$ldapConn = ldap_connect("minnie");
	if (!$ldapConn)
		throw new Exception("Impossible de se connecter !");
	ldap_set_option($ldapConn, LDAP_OPT_PROTOCOL_VERSION, 3);

	$ldapBind = ldap_bind($ldapConn);
	if (!$ldapBind)
		throw new Exception("Impossible de s'identifier");

	$ldapRecherche = ldap_search($ldapConn, "o=xulforum",
		"(&(uid=*)(objectClass=person))");
	if (!$ldapRecherche)
		throw new Exception("Impossible de chercher");

	$ldapResultats = @ldap_get_entries($ldapConn, $ldapRecherche);
	if (!$ldapResultats)
		throw new Exception("Aucun rÃ©sultat trouvÃ© !");

	for ($i = 0; $i < $ldapResultats["count"]; $i++) {
		//var_dump($ldapResultats[$i]);
		$e = $d->createElement("RDF:Description");
		$e->setAttribute("RDF:about", "http://www.xulforum.fr/utilisateurs/$i");
		$e->appendChild($d->createElement("XF:cn", $ldapResultats[$i]["cn"][0]));
		$e->appendChild($d->createElement("XF:description", $ldapResultats[$i]["description"][0]));
		$e->appendChild($d->createElement("XF:uid", $ldapResultats[$i]["uid"][0]));
		$e->appendChild($d->createElement("XF:l", $ldapResultats[$i]["l"][0]));
		$e->appendChild($d->createElement("XF:mail", $ldapResultats[$i]["mail"][0]));
		$r->appendChild($e);
	}

	$e = $d->createElement("RDF:Seq");
	$e->setAttribute("RDF:about", "http://www.xulforum.fr/utilisateurs");
	$r->appendChild($e);

	for ($i = 0; $i < $ldapResultats["count"]; $i++) {
		//var_dump($ldapResultats[$i]);
		$l = $d->createElement("RDF:li");
		$l->setAttribute("RDF:resource", "http://www.xulforum.fr/utilisateurs/$i");
		$e->appendChild($l);
	}


} catch (Exception $e) {
	exit($e->getMessage());
}


echo $d->saveXML();
?>
