var gConfig;

/* pour rcuprer les infos sur le serveur distant */

function ConfigServeur() {
	this.php = { hote: null, chemin: null, cheminrdf: null };
	this.ldap = { hote: null, baseDn: null};
	this.xml = null;
	this.url = null;
}

ConfigServeur.prototype.toString =
	function () {
		return "Configuration globale :\n"+
			"\tPHP :\n"+
			"\t\tHote "+this.php.hote+" :: Chemin "+this.php.chemin+"\n"+
			"\tLDAP :\n"+
			"\t\tHote "+this.ldap.hote+" :: BaseDN "+this.ldap.baseDn+"\n";
	};

function chargerParametres(pUrl) {
	try {
		var x = new XMLHttpRequest;
		x.open("GET", pUrl, false);
		x.send(null);
		if (x.status != 200) {
			throw new Error("HTTP "+x.status);
		}
	} catch (e) {
		ajouterErreur("Impossible d'obtenir le fichier de configuration !");
		ajouterErreur(e);
		return false;
		dump(e);
	}

	var config = x.responseXML;
	if (config == null) {
		ajouterErreur("Impossible de lire le fichier XML");
		return false;
	}
	gConfig = new ConfigServeur;
	gConfig.xml = config;
	gConfig.url = pUrl;

	var serveurs = config.getElementsByTagName("serveur");
	for (var i = 0; i < serveurs.length; i++) {
		var s = serveurs[i];
		switch (s.getAttribute("type")) {
			case "php" :
				gConfig.php.hote = s.getElementsByTagName("hote")[0].firstChild.data;
				gConfig.php.chemin = s.getElementsByTagName("chemin")[0].firstChild.data;
				gConfig.php.cheminrdf = s.getElementsByTagName("cheminrdf")[0].firstChild.data;
				break;
			case "ldap" :
				gConfig.ldap.hote = s.getElementsByTagName("hote")[0].firstChild.data;
				gConfig.ldap.baseDn = s.getElementsByTagName("baseDn")[0].firstChild.data;
				break;
		}
	}
	dump(gConfig);

	if (gConfig.ldap.hote == null && document.getElementById("xf-ident-opt-ignorer") != null)
		document.getElementById("xf-ident-opt-ignorer").setAttribute("checked", true);
	else if (document.getElementById("xf-ident-opt-ignorer"))
		document.getElementById("xf-ident-opt-ignorer").setAttribute("checked", false);
	if (document.getElementById("xf-ident-opt-dn"))
		document.getElementById("xf-ident-opt-dn").setAttribute("value", gConfig.ldap.baseDn);
	
	return true;
}

