<?php
	
	require 'cinedvd_session.php';
	
	session_begin('member_id', $PHP_SELF);	
	
?>

<?php
	
	require 'tools_db.php';
	require 'tools_xhtml.php';
	require_once 'globals_string_lang.php';
	require 'globals_db.php';
	
	xhtml_head("DVDTek");
	xhtml_body_start();	
	$link = db_connect($DSN);
	db_select($DSN, $link);
	$dvd_result = db_query($link, "SELECT * FROM dvds WHERE DVD_ID = '$dvd_id'");
	$dvd = db_result_fetch_assoc($dvd_result);

	$dvd_edition = "";
	$dvd_edition_result = db_get_by_id($dvd["DVD_ID"], "nom", "dvds", "dvds_dvdeditions", "dvdeditions", "DVD_ID", "DVDEdition_ID");
	while (($row = db_result_fetch_assoc($dvd_edition_result))) {
		$dvd_edition .= $row["nom"] . ", ";
	}
	$dvd_edition = substr("$dvd_edition", 0, -2);
	db_result_free($dvd_edition_result);

	$dvd_box = "";
	$dvd_box_result = db_query($link, "SELECT * FROM dvdbotiers WHERE DVDBotier_ID = '" . $dvd['DVDBotier_ID'] . "'");
	while (($row = db_result_fetch_assoc($dvd_box_result))) {
		$dvd_box .= $row["nom"];
	}
	db_result_free($dvd_box_result);
	
	$dvd_user = "";
	$dvd_user_result = db_query($link, "SELECT * FROM utilisateurs WHERE Utilisateur_ID = '" . $dvd['Possesseur_ID'] . "'");
	while (($row = db_result_fetch_assoc($dvd_user_result))) {
		$dvd_user_name = $row['nom'];
		$dvd_user_firstname = $row['prnom'];
		$dvd_user_nickname = $row['login'];
		$dvd_user_email = $row['email'];
	}
	db_result_free($dvd_user_result);

?>
	
	<table summary="<?=$string_lang['WIZARD_DVD_INFORMATION'][$lang]?>" class="dvdsummary" >
		<th colspan="2" class="summary" ><?=$string_lang['WIZARD_DVD_INFORMATION'][$lang]?></th>
		<tr><td><?=$string_lang['WIZARD_DVD_TITLE'][$lang]?></td><td class="info" ><?=$dvd['titre']?></td></tr>
		<tr><td><?=$string_lang['WIZARD_DVD_EDITION'][$lang]?></td><td class="info" ><?=$dvd_edition?></td></tr>
		<tr><td><?=$string_lang['WIZARD_DVD_BOX'][$lang]?></td><td class="info" ><?=$dvd_box?></td></tr>
		<tr><td><?=$string_lang['WIZARD_DVD_RELEASE_DATE'][$lang]?></td><td class="info" ><?=$dvd['dateDeSortie']?></td></tr>
		<tr><td><?=$string_lang['WIZARD_DVD_NUMBER_OF'][$lang]?></td><td class="info" ><?=$dvd['nombreDeDVD']?></td></tr>
		<tr><td><?=$string_lang['WIZARD_DVD_ZONE'][$lang]?></td><td class="info" ><?=$dvd['zone']?></td></tr>

<?php
	
	$movies_result = db_query($link, "SELECT * FROM dvds_films WHERE DVD_ID = '" . $dvd['DVD_ID'] . "'");
	$i = 0; 
	$nmovies = db_result_count($movies_result);
	while (($row = db_result_fetch_assoc($movies_result))) {
		$i++;		
		$movie_result = db_query($link, "SELECT * FROM films WHERE Film_ID = '" . $row['Film_ID'] . "'");
		$movie = db_result_fetch_assoc($movie_result);
		
		$movie_director = "";
		$movie_director_result = db_get_by_id($movie['Film_ID'], "*", "films", "films_ralisateurs", "ralisateurs", "Film_ID", "Ralisateur_ID");
		while (($row_director = db_result_fetch_assoc($movie_director_result))) {
			$movie_director .= $row_director["prnom"] . " " . $row_director["nom"] . ", ";
		}
		$movie_director = substr("$movie_director", 0, -2);
		db_result_free($movie_director_result);

		$movie_country = "";
		$movie_country_result = db_get_by_id($movie['Film_ID'], "*", "films", "films_pays", "pays", "Film_ID", "Pays_ID");
		while (($row_country = db_result_fetch_assoc($movie_country_result))) {
			$movie_country .= $row_country["nom"] . ", ";
		}
		$movie_country = substr("$movie_country", 0, -2);
		db_result_free($movie_country_result);

		$movie_category = "";
		$movie_category_result = db_get_by_id($movie['Film_ID'], "*", "films", "films_genres", "genres", "Film_ID", "Genre_ID");
		while (($row_category = db_result_fetch_assoc($movie_category_result))) {
			$movie_category .= $row_category["nom"] . ", ";
		}
		$movie_category = substr("$movie_category", 0, -2);
		db_result_free($movie_category_result);

?>

		<tr><td colspan="2">
		<table summary="<?=$string_lang['WIZARD_MOVIE_INFORMATION'][$lang]?><? if ($nmovies > 1) printf(" (%u)", $i); ?>" class="filmsummary" >
			<th colspan="2" class="summary" ><?=$string_lang['WIZARD_MOVIE_INFORMATION'][$lang]?><? if ($nmovies > 1) printf(" (%u)", $i); ?></th>
			<tr><td><?=$string_lang['WIZARD_MOVIE_TITLE_VF'][$lang]?></td><td class="info" ><?=$movie['titreFR']?></td></tr>
			<tr><td><?=$string_lang['WIZARD_MOVIE_TITLE_VO'][$lang]?></td><td class="info" ><?=$movie['titreVO']?></td></tr>
			<tr><td><?=$string_lang['WIZARD_MOVIE_RELEASE_DATE'][$lang]?></td><td class="info" ><?=$movie['anne']?></td></tr>
			<tr><td><?=$string_lang['WIZARD_MOVIE_DIRECTOR'][$lang]?></td><td class="info" ><?=$movie_director?></td></tr>
			<tr><td><?=$string_lang['WIZARD_MOVIE_COUNTRY'][$lang]?></td><td class="info" ><?=$movie_country?></td></tr>
			<tr><td><?=$string_lang['WIZARD_MOVIE_CATEGORY'][$lang]?></td><td class="info" ><?=$movie_category?></td></tr>
			<tr><td><?=$string_lang['WIZARD_MOVIE_LENGTH'][$lang]?></td><td class="info" ><?=$movie['dure']?></td></tr>
		</table>
		</td></tr>

<?php

	}
	db_result_free($movies_result);
	
?>
	
	</table>
	
<?php

	echo "<p>\n";	
	$subject = rawurlencode(sprintf("[CineDVD] %s \"%s\"", $string_lang['DVD_GET'][$lang], $dvd['titre']));
	$body = rawurlencode(sprintf($string_lang['DVD_GET_MSG'][$lang], $dvd_user_firstname, ($dvd['titre'] . " [" . $dvd_edition . "]")));
	$mailto = sprintf("mailto:%s?subject=%s&body=%s", $dvd_user_email, $subject, $body);
	printf("%s <a href=\"%s\">%s</a> (%s).\n", $string_lang['DVD_OWNED_BY'][$lang], $mailto, ($dvd_user_firstname . " " . $dvd_user_name), $dvd_user_nickname);
	echo "</p>\n";
	$result_lent = db_query($link, "SELECT DVD_ID, Utilisateur_ID FROM emprunts WHERE (daterendu='0' AND DVD_ID='$dvd_id')");
	$lent = db_result_count($result_lent);
	if (strcmp($dvd['Possesseur_ID'], $member_id) != 0)
	{
		if (!$lent) {
			if (!$sent)
			{
				echo "<form action=\"cinedvd_card.php\" >\n";
				echo "<input type=\"hidden\" name=\"dvd_id\" value=\"$dvd_id\" />\n";
				echo "<input type=\"hidden\" name=\"sent\" value=\"1\" />\n";
				echo "<p>\n";
				printf("<input type=\"submit\" value=\"%s\" class=\"submit\" />\n", $string_lang['DVD_LOAN'][$lang]);
				echo "</p>\n";
				echo "</form>\n";
			}
			else
			{
				$query = "INSERT INTO emprunts(DVD_ID, Utilisateur_ID, dateemprunt, Possesseur_ID) VALUES("
					. "'" . $dvd_id . "'" . ", "
					. "'" . $member_id . "'" . ", "
					. "NOW()" . ", "
					. "'" . $dvd['Possesseur_ID'] . "'"
					. ")";
				db_query($link, $query);
				printf("%s\n", $string_lang['DVD_LENT'][$lang]);
			}
		}
		else
		{
			$row_lent = db_result_fetch_assoc($result_lent);
			if (strcmp($row_lent['Utilisateur_ID'], $member_id) == 0)
			{
				if (!$sent)
				{
					echo "<form action=\"cinedvd_card.php\" >\n";
					echo "<input type=\"hidden\" name=\"dvd_id\" value=\"$dvd_id\" />\n";
					echo "<input type=\"hidden\" name=\"sent\" value=\"2\" />\n";
					echo "<p>\n";
					printf("<input type=\"submit\" value=\"%s\" class=\"submit\" />\n", $string_lang['DVD_GO_BACK'][$lang]);
					echo "</p>\n";
					echo "</form>\n";
				}
				else
				{
					$query = "UPDATE emprunts SET daterendu = NOW() WHERE (DVD_ID = '$dvd_id' AND daterendu=0)";
					db_query($link, $query);
					printf("%s\n", $string_lang['DVD_RETURNED'][$lang]);
				}
			}
			else
			{
				$dvd_lenter = "";
				$dvd_lenter_result = db_query($link, "SELECT * FROM utilisateurs WHERE Utilisateur_ID = '" . $row_lent['Utilisateur_ID'] . "'");
				while (($row = db_result_fetch_assoc($dvd_lenter_result))) {
					$dvd_lenter_name = $row['nom'];
					$dvd_lenter_firstname = $row['prnom'];
					$dvd_lenter_nickname = $row['login'];
					$dvd_lenter_email = $row['email'];
				}
				db_result_free($dvd_lenter_result);
				echo "<p>\n";	
				$subject = rawurlencode(sprintf("[CineDVD] %s \"%s\"", $string_lang['DVD_GET'][$lang], $dvd['titre']));
				$body = rawurlencode(sprintf($string_lang['DVD_GET_MSG'][$lang] . $string_lang['DVD_GET_MSG_LENT'][$lang], $dvd_lenter_firstname, ($dvd['titre'] . " [" . $dvd_edition . "]")));
				$mailto = sprintf("mailto:%s?subject=%s&body=%s", $dvd_lenter_email, $subject, $body);
				printf("%s <a href=\"%s\">%s</a> (%s).\n", $string_lang['DVD_LENT_BY'][$lang], $mailto, ($dvd_lenter_firstname . " " . $dvd_lenter_name), $dvd_lenter_nickname);
				echo "</p>\n";
			}
		}	    
	}
	
?>
	
<?php
	
   	db_disconnect($link);
	xhtml_foot();
	
?>
