# MySQL-Front Dump 2.2
#
# Host: localhost   Database: cinedvd
#--------------------------------------------------------
# Server version 3.23.49-nt


#
# Table structure for table 'dvdbotiers'
#

CREATE TABLE `dvdbotiers` (
  `DVDBotier_ID` tinyint(3) unsigned NOT NULL auto_increment,
  `nom` varchar(63) default NULL,
  PRIMARY KEY  (`DVDBotier_ID`),
  UNIQUE KEY `DVDBotier_ID` (`DVDBotier_ID`)
) TYPE=MyISAM;



#
# Table structure for table 'dvdeditions'
#

CREATE TABLE `dvdeditions` (
  `DVDEdition_ID` tinyint(3) unsigned NOT NULL auto_increment,
  `nom` varchar(31) default NULL,
  PRIMARY KEY  (`DVDEdition_ID`),
  UNIQUE KEY `DVDEdition_ID` (`DVDEdition_ID`)
) TYPE=MyISAM;



#
# Table structure for table 'dvds'
#

CREATE TABLE `dvds` (
  `DVD_ID` smallint(5) unsigned NOT NULL auto_increment,
  `titre` varchar(255) NOT NULL default '',
  `dateDeSortie` date default NULL,
  `DVDBotier_ID` tinyint(3) unsigned default NULL,
  `nombreDeDVD` tinyint(2) unsigned default '1',
  `zone` tinyint(1) unsigned default '2',
  `Possesseur_ID` tinyint(3) unsigned default '0',
  PRIMARY KEY  (`DVD_ID`),
  UNIQUE KEY `DVD_ID` (`DVD_ID`)
) TYPE=MyISAM;



#
# Table structure for table 'dvds_dvdeditions'
#

CREATE TABLE `dvds_dvdeditions` (
  `DVD_ID` smallint(5) unsigned NOT NULL default '0',
  `DVDEdition_ID` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`DVD_ID`,`DVDEdition_ID`)
) TYPE=MyISAM COMMENT='Table de liaison (DVDs <-> DVDEditions)';



#
# Table structure for table 'dvds_films'
#

CREATE TABLE `dvds_films` (
  `DVD_ID` int(10) unsigned NOT NULL default '0',
  `Film_ID` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`DVD_ID`,`Film_ID`)
) TYPE=MyISAM COMMENT='Table de liaison (DVDs <-> Films)';



#
# Table structure for table 'emprunts'
#

CREATE TABLE `emprunts` (
  `DVD_ID` smallint(5) unsigned NOT NULL default '0',
  `Utilisateur_ID` smallint(5) unsigned NOT NULL default '0',
  `dateemprunt` timestamp(14) NOT NULL,
  `daterendu` timestamp(14) NOT NULL,
  `Possesseur_ID` smallint(5) unsigned NOT NULL default '0',
  PRIMARY KEY  (`DVD_ID`,`Utilisateur_ID`)
) TYPE=MyISAM;



#
# Table structure for table 'films'
#

CREATE TABLE `films` (
  `Film_ID` smallint(5) unsigned NOT NULL auto_increment,
  `titreFR` varchar(255) NOT NULL default '',
  `titreVO` varchar(255) default NULL,
  `anne` year(4) default NULL,
  `dure` time default NULL,
  PRIMARY KEY  (`Film_ID`),
  UNIQUE KEY `Film_ID` (`Film_ID`)
) TYPE=MyISAM;



#
# Table structure for table 'films_genres'
#

CREATE TABLE `films_genres` (
  `Film_ID` int(10) unsigned NOT NULL default '0',
  `Genre_ID` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`Film_ID`,`Genre_ID`)
) TYPE=MyISAM COMMENT='Table de liaison (Films <-> Genres)';



#
# Table structure for table 'films_pays'
#

CREATE TABLE `films_pays` (
  `Film_ID` int(10) unsigned NOT NULL default '0',
  `Pays_ID` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`Film_ID`,`Pays_ID`)
) TYPE=MyISAM COMMENT='Table de liaison (Films <-> Pays)';



#
# Table structure for table 'films_ralisateurs'
#

CREATE TABLE `films_ralisateurs` (
  `Film_ID` int(10) unsigned NOT NULL default '0',
  `Ralisateur_ID` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`Film_ID`,`Ralisateur_ID`)
) TYPE=MyISAM COMMENT='Table de liaison (Films <-> Ralisateurs)';



#
# Table structure for table 'genres'
#

CREATE TABLE `genres` (
  `Genre_ID` tinyint(3) unsigned NOT NULL auto_increment,
  `nom` varchar(63) NOT NULL default '',
  PRIMARY KEY  (`Genre_ID`),
  UNIQUE KEY `Genre_ID` (`Genre_ID`)
) TYPE=MyISAM;



#
# Table structure for table 'pays'
#

CREATE TABLE `pays` (
  `Pays_ID` tinyint(3) unsigned NOT NULL auto_increment,
  `nom` varchar(63) NOT NULL default '',
  PRIMARY KEY  (`Pays_ID`),
  UNIQUE KEY `Pays_ID` (`Pays_ID`)
) TYPE=MyISAM;



#
# Table structure for table 'ralisateurs'
#

CREATE TABLE `ralisateurs` (
  `Ralisateur_ID` smallint(5) unsigned NOT NULL auto_increment,
  `nom` varchar(63) NOT NULL default '',
  `prnom` varchar(63) default NULL,
  PRIMARY KEY  (`Ralisateur_ID`),
  UNIQUE KEY `Ralisateur_ID` (`Ralisateur_ID`)
) TYPE=MyISAM;



#
# Table structure for table 'utilisateurs'
#

CREATE TABLE `utilisateurs` (
  `Utilisateur_ID` smallint(5) unsigned NOT NULL auto_increment,
  `nom` varchar(63) NOT NULL default '0',
  `prnom` varchar(63) NOT NULL default '0',
  `login` varchar(15) NOT NULL default '0',
  `pass` varchar(15) NOT NULL default '0',
  `admin` tinyint(1) unsigned NOT NULL default '0',
  `email` varchar(63) default NULL,
  PRIMARY KEY  (`Utilisateur_ID`)
) TYPE=MyISAM;

