<?php
	
	require_once 'tools_db.php';
	require_once 'tools_xhtml.php';
	require_once 'globals_string_lang.php';
	
#	function db_display_process_classic($query, $table, $name)
#	{
#		$sqlquery = array (
#			'all' => "SELECT COUNT(*) FROM $table WHERE $name LIKE '%". $query ."%'", 
#			'order_limit' => "SELECT * FROM $table WHERE $name LIKE '%". $query ."%' ORDER BY $name ASC LIMIT $page, $limit"
#			);
#		$info = db_display_process_classic($query, $sqlquery['all']);
#		$info['sqlquery_order_limit'] = $sqlquery['order_limit'];
#		return $info;
#	}
	
	function db_display_process($query, $sqlquery, $page, $limit)
	{
		global $link;
		global $string_lang;
		global $lang;
		
		
    	/* --- Define variables --- */
    	if (!isset($limit))
    	{
    		$limit = 10; /* Default results per-page */
    	}
    	if (!isset($page) or ($page < 0))
    	{
    		$page = 0; /* Default page value */
    	}
    	$numresults = db_query($link, $sqlquery); /* The query */
    	$numrows = db_result_count($numresults); /* Number of rows returned from above query */
    	if ($numrows == 0)
    	{
    		echo $string_lang['SEARCH_NO_MATCHING_RESULTS'][$lang] . " " . $query . "<br />\n"; /* Bah, modify the "Not Found" error for your needs */
#    		exit();
    	}
    	/* --- The Math --- */
    	$pages = intval($numrows/$limit); /* Number of results pages */
    	/* $pages now contains int of pages, unless there is a remainder from division */
    	if ($numrows % $limit)
    	{
    		$pages++; /* has remainder so add one page */
    	}
    	$current = intval($page/$limit) + 1; /* Current page number */
    	if ($pages < 1)
    	{
    		$total = 1; /* If $pages is less than one or equal to 0, total pages is 1 */
    	} 
    	else
    	{
    		$total = $pages; /* Else total pages is $pages value */
    	}
    	$first = $page + 1; /* The first result */
    	if (!((($page + $limit) / $limit) >= $pages) && $pages != 1)
    	{
    		$last = $page + $limit; /* If not last results page, last result equals $page plus $limit */
    	}
    	else
    	{
    		$last = $numrows; /* If last results page, last result equals total number of results */
    	}
		$info = array(
			'current' => $current, 
			'first' => $first, 
			'last' => $last, 
			'total' => $total, 
			'numrows' => $numrows, 
			'page' => $page, 
			'pages' => $pages, 
			'limit' => $limit
			);
		return $info;
	}
    
	
	function db_display_header($query, $info)
	{
		global $string_lang;
		global $lang;
?>
	
	<!-- Visual Tid-Bits -->
	<em class="db_display_emph"><?=$string_lang['SEARCH_MATCHING_RESULTS'][$lang]?> <?=$query?></em>
	<table width="100%" border="0">
		<tr>
			<td class="db_display_header_results" >
				<?=$string_lang['SEARCH_RESULTS'][$lang]?> <em class="db_display_emph"><?=$info['first']?></em> - <em class="db_display_emph"><?=$info['last']?></em> <?=$string_lang["SEARCH_RESULTS_OF"][$lang]?> <em class="db_display_emph"><?=$info['numrows']?></em>
			</td>
			<td class="db_display_header_pages">
				<?=$string_lang['SEARCH_PAGE'][$lang]?> <em class="db_display_emph"><?=$info['current']?></em> <?=$string_lang["SEARCH_PAGE_OF"][$lang]?> <em class="db_display_emph"><?=$info['total']?></em>
			</td>
		</tr>
		<tr>
			<td colspan="2" class="db_display_result_per_pages" >
				<?=$string_lang['SEARCH_RESULTS_PER_PAGE'][$lang]?> <a href="<?=$PHP_SELF?>?query=<?=$query?>&name=<?=$info['name']?>&order=<?=$info['order']?>&page=<?=$info['page']?>&limit=5">5</a> | <a href="<?=$PHP_SELF?>?query=<?=$query?>&name=<?=$info['name']?>&order=<?=$info['order']?>&page=<?=$info['page']?>&limit=10">10</a> | <a href="<?=$PHP_SELF?>?query=<?=$query?>&name=<?=$info['name']?>&order=<?=$info['order']?>&page=<?=$info['page']?>&limit=20">20</a> | <a href="<?=$PHP_SELF?>?query=<?=$query?>&name=<?=$info['name']?>&order=<?=$info['order']?>&page=<?=$info['page']?>&limit=50">50</a>
			</td>
		</tr>
	</table>
	<br />		
	
<?php
		
	}
	
	function db_display_footer($query, $info)
	{
		global $string_lang;
		global $lang;
		
		$page=$info['page'];
		$pages=$info['pages'];
		$limit=$info['limit'];
		$name=$info['name'];
		$order=$info['order'];
    	echo "<p class=\"db_display_footer\">";
    	/* --- Linking To Other Pages --- */
    	if ($page != 0)
    	{ /* Don't show back link if current page is first page */
    		$back_page = $page - $limit;
    		echo "<a href=\"$PHP_SELF?query=$query&name=$name&order=$order&page=$back_page&limit=$limit\">" . $string_lang["SEARCH_PREVIOUS_PAGE"][$lang] . "</a>\n";
    	}
    	for ($i=1; $i <= $pages; $i++) /* Loop through each page and give link to it */
    	{
    		$ppage = $limit * ($i-1);
    		if ($ppage == $page)
    		{
    			echo "<em class=\"db_display_emph\">$i</em>\n";
    		} /* If current page don't give link, just text */
    		else
    		{
    			echo "<a href=\"$PHP_SELF?query=$query&name=$name&order=$order&page=$ppage&limit=$limit\">$i</a>\n";
    		}
    	}
    	if (!((($page+$limit) / $limit) >= $pages) && $pages != 1)
    	{ /* If last page don't give next link */
    		$next_page = $page + $limit;
    		echo "<a href=\"$PHP_SELF?query=$query&name=$name&order=$order&page=$next_page&limit=$limit\">" . $string_lang["SEARCH_NEXT_PAGE"][$lang] . "</a>\n";
    	}
    	echo "</p>";
	}
	
?>
