<?php
	
	require 'tools_xhtml.php';
	require 'tools_string.php';
	
	require_once 'globals_string_lang.php';

	require 'tools_wizard_trackvars.php';
	
	function wizard_header($title)
	{
		xhtml_head($title);
		xhtml_body_start();

	}
	
	function wizard_footer()
	{
		xhtml_foot();
	}
	
	function wizard_form_start($wizard)
	{
		printf("<form method=\"post\" action=\"$wizard\" >\n");
	}
	
	function wizard_form_end($step, $step_min, $step_max)
	{
		global $string_lang;
		global $lang;
		printf("<p>\n");
		printf("<br />\n");
		if ($step > $step_min) {
			printf("(" . $string_lang['WIZARD_PREVIOUS'][$lang] . ")&nbsp;<b>[ Etape</b><input type=\"submit\" name=\"step\" value=\"%u\" class=\"submit\" /><b> ]</b>\n", $step-1);
		} else {
			printf("(" . $string_lang['WIZARD_START'][$lang] . ")\n");
		}
		printf("<b>&nbsp;&lt;&nbsp;&gt;&nbsp;</b>");
		if ($step < $step_max) {
			printf("<b>[ " . $string_lang['WIZARD_STEP'][$lang] . "</b><input type=\"submit\" name=\"step\" value=\"%u\" class=\"submit\" /><b> ]</b>&nbsp;(" . $string_lang['WIZARD_NEXT'][$lang] . ")\n", $step+1);
		} else {
			printf("(" . $string_lang['WIZARD_END'][$lang] . ")\n");
		}
		printf("<br /><br />\n");
		printf("%s \n", $string_lang['WIZARD_STEPS_DIRECT_GOTO'][$lang]);
		for ($i = $step_min; $i < $step_max; $i++) {
			printf("<input type=\"submit\" name=\"step\" value=\"$i\" class=\"submit\" />&nbsp;\n");
		}
		printf("</p>\n");
		printf("</form>\n");
	}
	
/**
	function wizard_end($title)
	{
		printf("<h1>\n\t%s\n</h1>", $title);
		printf("<h2>\n\tVous pouvez maintenant fermer la fentre.\n</h2>");
	}
*/
	
?>
