/*
 * Cr le 14 aot 2004
 *
 * Codes Open Source pour Le Cahier du Programmeur Java[3] : 
 *		Java & XML: Le mariage de deux technologies complmentaires et autonomes
 * 
 * Auteur : R.Fleury (renaud.fleury@free.fr)
 */
package com.automne.octopuss.junit.webservices;

import java.net.MalformedURLException;
import java.rmi.RemoteException;

import javax.xml.namespace.QName;
import javax.xml.rpc.ParameterMode;
import javax.xml.rpc.ServiceException;

import junit.framework.TestCase;

import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.encoding.XMLType;

/**
 * Projet  : Octopuss
 * Classe  : TestEchoWebService
 * Version : 1.0
 * But     : Tester le service Web EchoWebService.
 * 
 */
public class TestEchoWebService extends TestCase {

	/**
	 * Constructeur par dfaut
	 */
	public TestEchoWebService() {
		super();
	}

	/**
	 * Constructeur spcifiant le nom du test
	 */
	public TestEchoWebService(String arg0) {
		super(arg0);		
	}
	/**
	 * Mthode de test du service EchoWebService dploy en tant que service .jws
	 */
	public void testEchoWebServiceJws(){
	    String endpoint = "http://localhost:8081/axis/EchoWebServices.jws";
	    String method = "echo";
	    Service  service = new Service();
	    Call     call;
	    try {
			call = (Call) service.createCall();
			call.setTargetEndpointAddress( new java.net.URL(endpoint) );
		    call.setOperationName( method );
		    call.addParameter( "firstParameter", XMLType.XSD_STRING, ParameterMode.IN );
		    call.setReturnType( XMLType.XSD_STRING);
		    String  ret = (String) call.invoke( new Object [] { "From testEchoWebServiceJws" });
		    System.out.println("Got result : " + ret);
		    assertTrue(true);
		} catch (ServiceException e) {
			e.printStackTrace();
			assertTrue(false);
		} catch (MalformedURLException e) {			
			e.printStackTrace();assertTrue(false);
		} catch (RemoteException e) {
			e.printStackTrace();assertTrue(false);
		}
	}
	/**
	 * Mthode de test du service EchoWebService dploy  travers l'outil d'administration d'Axis
	 */
	public void testEchoWebServiceDeployed(){
	    String endpoint = "http://localhost:8081/axis/services/echoService";
	       Service  service = new Service();
	    Call call;
	    try {
			call = (Call) service.createCall();
			call.setTargetEndpointAddress( new java.net.URL(endpoint) );
		    call.setOperationName( new QName("EchoWebServices","echo") );
		    call.addParameter( "str", XMLType.XSD_STRING, ParameterMode.IN );
		    call.setReturnType( XMLType.XSD_STRING);
		    String  ret = (String) call.invoke( new Object [] { "From testEchoWebServiceDeployed" });
		    System.out.println("Got result : " + ret);
		    assertTrue(true);
		} catch (ServiceException e) {
			e.printStackTrace();
			assertTrue(false);
		} catch (MalformedURLException e) {			
			e.printStackTrace();assertTrue(false);
		} catch (RemoteException e) {
			e.printStackTrace();assertTrue(false);
		}
	}
}
