/*
 * Cr le 14 dc. 2003
 *
 * Codes Open Source pour Le Cahier du Programmeur Java[3] : 
 *		Java & XML: Le mariage de deux technologies complmentaires et autonomes
 * 
 * Auteur : R.Fleury (renaud.fleury@free.fr)
 */
package com.automne.octopuss.junit.xml;

import javax.xml.transform.TransformerException;

import junit.framework.TestCase;

import com.automne.octopuss.xml.IXmlService;
import com.automne.octopuss.xml.XMLServiceFacade;

/**
 * Projet  : Octopuss
 * Classe  : TestXmlTransformation
 * Version : 1.0
 * But     : Classe de test de transformation de flux XML
 * 
 */
public class TestXmlTransformation extends TestCase {

	/**
	 *	Constructeur par dfaut. 
	 */
	public TestXmlTransformation() {
		super();
	}

	/**
	 * Constructeur contenant le nom du test!
	 * @param arg0
	 */
	public TestXmlTransformation(String arg0) {
		super(arg0);

	}
	/**
	 * Mthode de test de la transformation de flux XML via la fabrique de services XML 
	 */
	public void testXMLTransform(){
		//Accs au service XML  travers une faade unique
		IXmlService xmlServices = XMLServiceFacade.getInstance().getXmlService();
		//Configuration du flux XML et XSL pour transformation vers du HTML.
		String xmlFile = "xml-content/LIVRE-CDP-JX.xml";
		String xslFile = "xml-content/xsl/livre.xsl";
		try {
			//Transformation!
			xmlServices.transformXml2Html(xmlFile,xslFile,System.out);
			//L'ternel test de russite du test unitaire JUnit
			assertTrue("Russite de la transformation",true);
		} catch (TransformerException e) {
			//On affiche la pile de l'erreur
			e.printStackTrace();
			//On rend le test en chec, via une ruse dont on connait le rsultat!
			assertFalse("Echec de la transformation",true);
		}
	}
	

}
