/*
 * Cr le 9 nov. 2003
 *
 * Codes Open Source pour Le Cahier du Programmeur Java[3] : 
 *		Java & XML: Le mariage de deux technologies complmentaires et autonomes
 * 
 * Auteur : R.Fleury (renaud.fleury@free.fr)
 */
package com.automne.octopuss.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;


/**
 * Interface dfinissant les fournisseurs de flux d'entre. Permet de lire indiffrement les flux durant 
 * les tests et dans Tomcat
 */
public interface InputStreamProvider {
	/**
	 * Retourne le flux d'entre correspondant au nom de fichier (Evidement relatif) pass en argument.
	 * @return un flux d'entre pour ce fichier
	 */
	public InputStream getInputStream() throws IOException;

	/**
	 * Retourne l'objet File associ au chemin pass en paramtre
	 * @return File
	 */
	public File getFile();
}
