/*
 * Cr le 9 nov. 2003
 *
 * Codes Open Source pour Le Cahier du Programmeur Java[3] : 
 *		Java & XML: Le mariage de deux technologies complmentaires et autonomes
 * 
 * Auteur : R.Fleury (renaud.fleury@free.fr)
 */
package com.automne.octopuss.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

import org.apache.log4j.Logger;


class LocalFileProvider implements InputStreamProvider {

	private static Logger logger = Logger.getLogger(LocalFileProvider.class);
	
	private String fileName= null;
	
	public LocalFileProvider(String file){
		fileName=file;
	}
	public InputStream getInputStream() throws IOException {
		logger.debug("trying to open file "+getFile().getAbsolutePath());
		return new FileInputStream(getFile());
	}

	public File getFile() {
		if(fileName.startsWith("/")) {
			fileName = fileName.substring(1);
		}
		File usedFile = new File(fileName);
		return usedFile;
	}

}
