/*
 * Cr le 14 dc. 2003
 *
 * Codes Open Source pour Le Cahier du Programmeur Java[3] : 
 *		Java & XML: Le mariage de deux technologies complmentaires et autonomes
 * 
 * Auteur : R.Fleury (renaud.fleury@free.fr)
 */
package com.automne.octopuss.xml;

import com.automne.octopuss.xml.impl.XMLServiceFactory;

/**
 * Projet  : Octopuss
 * Classe  : XMLServiceFacade
 * Version : 1.0
 * But     : Fournir un point d'entre aux services XML pour le projet Octopuss.
 * 
 */
public class XMLServiceFacade {

	/**
	 * Instance static du singleton.
	 */
	private static XMLServiceFacade instance = null;
	/**
	 * Fabrique des services XML.
	 */
	private IXmlService xmlService = null;
	/**
	 *	 Constructeur priv : principe du singleton
	 */
	private XMLServiceFacade() {
		super();
		xmlService = new XMLServiceFactory();
	}
	/**
	 * Mthode de rcupration de la facade des services XML du projet Octopuss
	 * @return
	 */
	public synchronized static XMLServiceFacade getInstance(){
		if (instance==null){
			instance= new XMLServiceFacade();
		}
		return instance;
	}

	/**
	 * Mthode permettant de rcuprer le service XML
	 * @return IXmlService
	 */
	public IXmlService getXmlService() {
		return xmlService;
	}

}
