/*
 * Cr le 28 dc. 2003
 *
 * Codes Open Source pour Le Cahier du Programmeur Java[3] : 
 *		Java & XML: Le mariage de deux technologies complmentaires et autonomes
 * 
 * Auteur : R.Fleury (renaud.fleury@free.fr)
 */
package com.automne.octopuss.xml.parsing.config.impl;

import org.apache.commons.digester.Digester;
import org.apache.commons.digester.Rule;
import org.apache.commons.digester.RuleSetBase;
import org.xml.sax.Attributes;

import com.automne.octopuss.xml.parsing.config.IOctopussDataSourceConfig;

/**
 * Projet  : Octopuss
 * Classe  : OctopussConfigRulesSet
 * Version : 1.0
 * But     : Classes de rgles de parsing via Digester du fichier OctopussConfig.xml
 * 
 */
public class OctopussConfigRulesSet extends RuleSetBase {

	/**
	 * 
	 */
	public OctopussConfigRulesSet() {
		super();		
	}

	/* (non-Javadoc)
	 * @see org.apache.commons.digester.RuleSet#addRuleInstances(org.apache.commons.digester.Digester)
	 */
	public void addRuleInstances(Digester digester) {
		digester.addObjectCreate
		("octopuss-config/data-sources/data-source",
				"com.automne.octopuss.xml.parsing.config.impl.OctopussDataSourceConfigImpl");
		digester.addSetProperties("octopuss-config/data-sources/data-source");
		digester.addSetNext("octopuss-config/data-sources/data-source",
				"addDataSourceConfig",
				"com.automne.octopuss.xml.parsing.config.impl.OctopussDataSourceConfigImpl");

		digester.addRule("octopuss-config/data-sources/data-source/set-property",new AddDataSourcePropertyRule());		
	}
	
	/**
	* Classe prive ayant pour but de symboliser une rgle du digester:
	* 		- A chaque cl-valeur on construit		
	*/
	private final class AddDataSourcePropertyRule extends Rule {
	/**
     * Constructeur par dfaut
     */
    public AddDataSourcePropertyRule() {
        super();
    }
	/**
	* Mthode permettant de rajouter des instructions lors du parsing du flux XML. Elle prend 
	* en compte le nom de l'lment et de l'espace de noms! Dans cette rgle, il ne faut initialiser 
	* que les attributs property-value.  
	*/
    public void begin(String name,String element,Attributes attributes) throws Exception {
        IOctopussDataSourceConfig dsc = (IOctopussDataSourceConfig) digester.peek();
        dsc.addProperty(attributes.getValue("property"),
                        attributes.getValue("value"));
    }

}


}
