package com.automne.octopuss.xml.parsing.config.impl;


import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import com.automne.octopuss.xml.parsing.config.IOctopussDataSourceConfig;

public class OctopussDataSourceConfigImpl implements IOctopussDataSourceConfig {

    private String key = "DATA_SOURCE_KEY";


    private HashMap properties = new HashMap();


    private String type = "org.apache.commons.dbcp.BasicDataSource";


   
    /**
     * Add a new custom configuration property.
     *
     * @param name Custom property name
     * @param value Custom property value
     */
    public void addProperty(String name, String value) {
       properties.put(name, value);
    }
    public String getKey() {
        return (this.key);
    }
    public Map getProperties() {
        return (this.properties);
    }
    public String getType() {
        return (this.type);
    }
    public void setKey(String key) {
       this.key = key;
    }
    public void setType(String type) {
        this.type = type;
    }
    /**
     * Return a String representation of this object.
     */
    public String toString() {

        StringBuffer sb = new StringBuffer("DataSourceConfig[");
        sb.append("key=");
        sb.append(key);
        sb.append(",type=");
        sb.append(type);
        Iterator names = properties.keySet().iterator();
        while (names.hasNext()) {
            String name = (String) names.next();
            String value = (String) properties.get(name);
            sb.append(',');
            sb.append(name);
            sb.append('=');
            sb.append(value);
        }
        sb.append("]");
        return (sb.toString());

    }


}
