/*
/*
 * Cr le 14 aot 2004
 *
 * Codes Open Source pour Le Cahier du Programmeur Java[3] : 
 *		Java & XML: Le mariage de deux technologies complmentaires et autonomes
 * 
 * Auteur : R.Fleury (renaud.fleury@free.fr)
 */
package com.automne.octopuss.xmldb;


import java.io.IOException;

import org.xml.sax.SAXException;

import com.automne.octopuss.xmldb.commandes.XmlDbCommandException;

/**
 * Projet  : Octopuss
 * Classe  : IXmlRpcCommands
 * Version : 1.0
 * But     : Symbolise l'ensemble des commandes possibles XML-RPC pour Octopuss 
 * 
 */
public interface IXmlRpcCommands {
	/**
	 * Execution d'une commande XML-RPC.
	 * @param cmds la commande XML-RPC
	 * @return String : donnes de sortie au format chaine
	 * @throws IOException
	 * @throws SAXException
	 * @throws XmlDbCommandException
	 */
	public String run(String cmds) throws IOException, SAXException, XmlDbCommandException;
}
