/*
 * Cr le 28 aot 2003
 *
 * Codes Open Source pour Le Cahier du Programmeur Java[3] : 
 *		Java & XML: Le mariage de deux technologies complmentaires et autonomes
 * 
 * Auteur : R.Fleury (renaud.fleury@free.fr)
 */
package com.automne.octopuss.xmldb;

import org.apache.commons.digester.Digester;
import org.apache.commons.digester.Rule;
import org.apache.commons.digester.RuleSetBase;
import org.xml.sax.Attributes;

import com.automne.octopuss.xmldb.commandes.AbstractCommande;

/**
 * Projet  : Octopuss
 * Classe  : XmlRpcRulesSet
 * Version : 1.0
 * But     : Classes de rgles de parsing via Digester de flux de commandes RPC
 * 
 */
public class XmlRpcRulesSet extends RuleSetBase {

	/**
	 * 
	 */
	public XmlRpcRulesSet() {
		super();		
	}

	/* (non-Javadoc)
	 * @see org.apache.commons.digester.RuleSet#addRuleInstances(org.apache.commons.digester.Digester)
	 */
	public void addRuleInstances(Digester digester) {
		digester.addObjectCreate("octopuss/xmldb/commande",
				"com.automne.octopuss.xmldb.commandes.AbstractCommande");
		digester.addSetProperties("octopuss/xmldb/commande");
		digester.addSetNext("octopuss/xmldb/commande",
				"addCommande",
				"com.automne.octopuss.xmldb.commandes.AbstractCommande");
		//Ajout de la regle pour gestion des paramtres indtermines commandes 	
		digester.addRule("octopuss/xmldb/commande/parametre",new AddOptionPropertyRule());	
		
	}
	
	/**
	* Classe prive ayant pour but de symboliser une rgle du digester:
	* 		- A chaque cl-valeur on construit l'option adquate pour la commande.		
	*/
	private final class AddOptionPropertyRule extends Rule {
	/**
     * Constructeur par dfaut
     */
    public AddOptionPropertyRule() {
        super();
    }
	/**
	* Mthode permettant de rajouter des instructions lors du parsing du flux XML. Elle prend 
	* en compte le nom de l'lment et de l'espace de noms! Dans cette rgle, il ne faut initialiser 
	* que les attributs property-value.  
	*/
    public void begin(String name,String element,Attributes attributes) throws Exception {
    	AbstractCommande dsc = (AbstractCommande) digester.peek();
        dsc.addParam(attributes.getValue("value"));
    }

}


}
