/*
 * Cr le 18 juillet 2004
 * 
 * Codes Open Source pour Le Cahier du Programmeur Java[3] : 
 *		Java & XML: Le mariage de deux technologies complmentaires et autonomes
 * 
 * Auteur : R.Fleury (renaud.fleury@free.fr)
 */
package com.automne.octopuss.junit.db;

import java.io.File;
import java.io.IOException;

import junit.framework.TestCase;

import org.xmldb.api.base.Collection;
import org.xmldb.api.base.ResourceIterator;
import org.xmldb.api.base.ResourceSet;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.XMLResource;
import org.xmldb.api.modules.XPathQueryService;

import com.automne.octopuss.xml.db.ExistDBManager;

/**
 * Projet  : Octopuss
 * Classe  : TestExistDBManager
 * Version : 1.0
 * But     : Classe de test du Service de management d'accs  une base de donnes XML natives : Exist
 */
public class TestExistDBManager extends TestCase {

	/**
	 * Constructeur par dfaut.
	 */
	public TestExistDBManager() {
		super();
		
	}
	ExistDBManager existDbManager=null;
	
	public void setUp()throws Exception{
		try {
			//	Initialisation par constructeur du DBManager pour la base XML native Exist
			existDbManager = new ExistDBManager("c:/eclipse/octopuss/Octopuss/database/conf.xml","localhost","8081","admin","");
		} catch (ClassNotFoundException e) {
			e.printStackTrace();
			assertTrue("Echec de la cration de la base de donnes octopuss!",false);
		} catch (InstantiationException e) {
			e.printStackTrace();
			assertTrue("Echec de la cration de la base de donnes octopuss!",false);
		} catch (IllegalAccessException e) {
			e.printStackTrace();
			assertTrue("Echec de la cration de la base de donnes octopuss!",false);
		} catch (XMLDBException e) {
			e.printStackTrace();
			assertTrue("Echec de la cration de la base de donnes octopuss!",false);
		}
	}
	/**
	 * Constructeur avec 1 argument: le nom de test.
	 */
	public TestExistDBManager(String arg0) {
		super(arg0);		
	}
	/**
	 * Mthode de test de la cration d'une collection dans Exist, base de donnes XML natives. 
	 */
	public void testDBManager(){
		try {
			//Cration des diffrentes collections!
			existDbManager.createCollection("db","octopuss");
			existDbManager.createCollection("db/octopuss","livres");
			existDbManager.createCollection("db/octopuss/livres","informatique");
			existDbManager.createCollection("db/octopuss/livres","droit-informatique");
			//Stockage de tous les flux XML d'un rpertoire dans le rep informatique.
			existDbManager.storeDataDirectoryInCollection(new File("c:/eclipse/octopuss/Octopuss/xml-content/db-XML/"),"db/octopuss/livres/informatique");
			//On s'est tromp il y a des livres de droit d'informatique dans le rpertoire ci-dessus!
			//Interrogeons par XQuery quels sont les ressources XML concerns.
			XPathQueryService service = (XPathQueryService)
			existDbManager.getRootCollection().getService("XPathQueryService", "1.0");
			//On recherche les feuilles XML dont l'id du titre contient DROIT
			String query = "for $R in collection('db/octopuss/livres/informatique') where contains($R/livre/@id,'DROIT')and contains($R/livre/@id,'INFORMATIQUE') return $R";
			ResourceSet resultSet= service.query(query);
			//Parcours des Ressources pour suppression de la rubrique "db/octopuss/livres/informatique"
			ResourceIterator it = resultSet.getIterator();
			while (it.hasMoreResources()){
				//On rcupre la ressource XML 
				XMLResource res= (XMLResource)it.nextResource();
				Collection infoCol = existDbManager.getCollection("db/octopuss/livres/informatique");
				XMLResource resV= (XMLResource)infoCol.getResource(res.getDocumentId());
				//pour la restocker au bon endroit!
				existDbManager.storeDataInCollection(resV,"db/octopuss/livres/droit-informatique");
				//pour la supprimer
				existDbManager.removeRessource(resV,"db/octopuss/livres/informatique");
				//	existDbManager.removeRessource(resV,"db/octopuss/livres/informatique");
		//		existDbManager.storeDataDirectoryInCollection(new File("c:/eclipse/octopuss/Octopuss/xml-content/db-XML/"),"db/octopuss/livres/droit-informatique");
			}
		} catch (ClassNotFoundException e) {
			e.printStackTrace();
			assertTrue("Echec de la cration de la base de donnes octopuss!",false);
			e.printStackTrace();
		} catch (InstantiationException e) {
			e.printStackTrace();
			assertTrue("Echec de la cration de la base de donnes octopuss!",false);
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			e.printStackTrace();
			assertTrue("Echec de la cration de la base de donnes octopuss!",false);
			e.printStackTrace();
		} catch (XMLDBException e) {
			e.printStackTrace();
			assertTrue("Echec de la cration de la base de donnes octopuss!",false);			
		} catch (IOException e) {
			e.printStackTrace();
			assertTrue("Echec de la cration de la base de donnes octopuss!",false);		
		}
		assertTrue("Succs de la cration de la base de donnes octopuss!",true);
	}

}
