/*
 * Cr le 11 nov. 2003
 *
 * Codes Open Source pour Le Cahier du Programmeur Java[3] : 
 *		Java & XML: Le mariage de deux technologies complmentaires et autonomes
 * 
 * Auteur : R.Fleury (renaud.fleury@free.fr)
 */
package com.automne.octopuss.junit.log4j;

import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

/**
 * Projet  : Octopuss
 * Classe  : Operations
 * Version : 1.0
 * But     : Fournir les oprations de base (addition, soustraction,
 * 			 multiplication, division) pour des nombres avec des contrles
 * 
 */
public class Operations {
		/**
		 * Constantes dfinissant le chemin d'accs au fichier de configuration de log4j.
		 */
		private static final String LOG4J_PROPERTIES_FILE_NAME = "conf/log4j.properties";

		/**
		 * Logger de la classe TestLog4j : Best Practices: 1 logger dfini pour chaque classe
		 */
		private static Logger logger = Logger.getLogger(Operations.class);

		/**
		 * Bloc Static servant  initialiser le logger!
		 */
		{
			//Appel au configurateur de proprits bien dfinies.	
			PropertyConfigurator.configure(LOG4J_PROPERTIES_FILE_NAME);	
		}
		
		/**
		 * Mthode de division de a/b
		 * @param a
		 * @param b
		 * @return le rsultat de la division de a/b
		 * @throws ArithmeticException
		 */	
		public static float division(float a,float b) throws DivisionException{
			if (b==0){
				logger.warn("division par 0 impossible :"+a+"/"+b+" lvera une DivisionByZeroException...");
				throw new DivisionException("le dnominateur pass  la mthode Division vaut 0, l'exception DivisionByZeroException est leve...");
			}
			return a/b;		
		}
}
