/*
 * Cr le 14 aot 2004
 *
 * Codes Open Source pour Le Cahier du Programmeur Java[3] : 
 *		Java & XML: Le mariage de deux technologies complmentaires et autonomes
 * 
 * Auteur : R.Fleury (renaud.fleury@free.fr)
 */
package com.automne.octopuss.junit.webservices;

import java.io.IOException;
import java.util.Vector;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.rpc.ServiceException;

import junit.framework.TestCase;

import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.message.SOAPBodyElement;
import org.apache.axis.utils.XMLUtils;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.output.DOMOutputter;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

/**
 * Projet  : Octopuss
 * Classe  : TestMessageXmlRpcCommandService
 * Version : 1.0
 * But     : Tester le service Web TestMessageXmlRpcCommandService.
 * 
 */
public class TestMessageXmlRpcCommandService extends TestCase {

	/**
	 * Constructeur par dfaut
	 */
	public TestMessageXmlRpcCommandService() {
		super();		
	}

	/**
	 * Constructeur  un argument: le nom du test
	 * @param arg0
	 */
	public TestMessageXmlRpcCommandService(String arg0) {
		super(arg0);
	}
	/**
	 * Mthode de test du service TestMessageXmlRpcCommandService
	 * @throws ServiceException
	 * @throws ParserConfigurationException
	 * @throws SAXException
	 * @throws IOException
	 * @throws JDOMException
	 */
	public void testService() throws ServiceException, ParserConfigurationException, SAXException, IOException, JDOMException{
	   //Instanciation de la classe reprsentant un service Web
		Service service = new Service();
		//Obtention d'un objet Call reprsentant un appel vers ce service Web.
	    Call call = (Call) service.createCall();
	    //On affecte  l'appel l'url du service en question
	    call.setTargetEndpointAddress("http://localhost:8080/axis/services/MessageXmlRpc");
	    //On prvoit les diffrentes parties du contenu de l'enveloppe
	    SOAPBodyElement[] input = new SOAPBodyElement[1];
	    Element rootElement = new Element("octopuss");
	    Element cmds = new Element("xmldb");
	    Element cmd = new Element("commande");
	    cmd.setAttribute("uriDb","http://localhost:8081/exist/xmlrpc/");
	    cmd.setAttribute("name","createCollection");
	    Element paramElement = new Element("parametre");
	    cmd.setAttribute("value","test");
	    cmd.addContent(paramElement);
	    cmds.addContent(cmd);
	    rootElement.addContent(cmds);
	    Document doc = new DOMOutputter().output(new org.jdom.Document(rootElement));
	    input[0] = new SOAPBodyElement(XMLUtils.StringToElement("http://rfm.no-ip.org", 
                "octopuss",""));
	    Vector elems = (Vector) call.invoke( input );
	    
}

}
