/*
 * Cr le 14 dc. 2003
 *
 * Codes Open Source pour Le Cahier du Programmeur Java[3] : 
 *		Java & XML: Le mariage de deux technologies complmentaires et autonomes
 * 
 * Auteur : R.Fleury (renaud.fleury@free.fr)
 */
package com.automne.octopuss.junit.xml;

import java.io.FileNotFoundException;
import java.io.FileReader;

import junit.framework.TestCase;

import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;

import com.automne.octopuss.xml.data.Livre;

/**
 * Projet  : Octopuss
 * Classe  : 
 * Version : 
 * But     :
 * 
 */
public class TestUnMarshallingBook extends TestCase {

	/**
	 * Constructeur par dfaut
	 */
	public TestUnMarshallingBook() {
		super();
		
	}

	/**
	 * Constructeur  un argument : Spcification du nom du test
	 */
	public TestUnMarshallingBook(String arg0) {
		super(arg0);
	}
	/**
	 * Mthode de test de dsrialisation d'un flux XML  travers l'utilisation du Marshaller / UnMarshaller de Castor!
	 *
	 */
	public void testUnMarshallingBook(){
		String xmlFile = "xml-content/LIVRE-TEST.xml";
		Livre livre = null;
		try {
			//Instantiation du Marshaller de Castor
			Unmarshaller marshal = new Unmarshaller();
			//On desserialise le flux XML en question
			livre = (Livre)Unmarshaller.unmarshal(Livre.class, new FileReader(xmlFile));
			//On vrifie que l'objet est correct!
			assertNotNull("Objet Livre Non Null => Dsrialisation Russie",livre);
			//Sortie du nom de l'auteur du flux XML reprsentant un livre dans la console! 
			System.out.println(livre.getAuteur()[0]);
		} catch (MarshalException e) {
			e.printStackTrace();
			assertNotNull("Objet Livre Null => Echec Dsrialisation",livre);
		} catch (ValidationException e) {
			e.printStackTrace();
			assertNotNull("Objet Livre Null => Echec Dsrialisation",livre);
		} catch (FileNotFoundException e) {
			e.printStackTrace();
			assertNotNull("Objet Livre Null => Echec Dsrialisation",livre);
		}		
	}
	public void testMarshallingBook(){
//			String xmlFile = "xml-content/TEST.xml";
//			TestLivre livre = null;
//			try {
//				livre = new TestLivre();
//				livre.setAuteur("Fleury");
//				livre.setTitre("Va te faire cuire un oeuf, sacha de mes couilles");
//				Marshaller marshal = new Marshaller(new FileWriter(xmlFile));
//				marshal.marshal(livre);
//				assertNotNull("Objet Livre Non Null => Srialisation Russie",livre);
//				Reader reader = new FileReader(xmlFile);
//				Unmarshaller um = new Unmarshaller(TestLivre.class);
//				TestLivre l = (TestLivre)um.unmarshal(reader);
//				assertNotNull("Objet Livre Non Null => Dsrialisation Russie",l);
//			} catch (MarshalException e) {
//				e.printStackTrace();
//				assertNotNull("Objet Livre Null => Echec Dsrialisation",livre);
//			} catch (ValidationException e) {
//				e.printStackTrace();
//				assertNotNull("Objet Livre Null => Echec Dsrialisation",livre);
//			} catch (FileNotFoundException e) {
//				e.printStackTrace();
//				assertNotNull("Objet Livre Null => Echec Dsrialisation",livre);
//			} catch (IOException e) {
//				e.printStackTrace();
//			}		
		}

}
