/*
 * Cr le 30 nov. 2003
 *
 * Codes Open Source pour Le Cahier du Programmeur Java[3] : 
 *		Java & XML: Le mariage de deux technologies complmentaires et autonomes
 * 
 * Auteur : R.Fleury (renaud.fleury@free.fr)
 */
package com.automne.octopuss.junit.xml.parsing;

import junit.framework.TestCase;

import com.automne.octopuss.xml.parsing.ParserSaxXml;
import com.automne.octopuss.xml.parsing.SaxParsingException;

/**
 * Projet  : Octopuss
 * Classe  : TestParserSax
 * Version : 1.0
 * But     : Tester la classe ParserSaxXml qui offre 3 mthodes de parsing de flux xml
 * 
 */
public class TestParserSax extends TestCase {

	/**
	 * Le nom du fichier XML  parzer.
	 */
	private String file2Parse = "xml-content/LIVRE-CDP-JX.xml";
	/**
	 * Constructeur par dfaut. 
	 */
	public TestParserSax() {
		super();
	}

	/**
	 * Constructeur  1 argument
	 * @param arg0
	 */
	public TestParserSax(String arg0) {
		super(arg0);
	}
	/**
	 * Mthode de parsing de flux XML sans validation.
	 */
	public void testParsingWithoutValidation() {
		ParserSaxXml parser = new ParserSaxXml();
		try {
			parser.parsingwithoutValidation(file2Parse);
			assertTrue("Parsing sans Validation russie", true);
		} catch (SaxParsingException e) {
			e.printStackTrace();
			throw new AssertionError();
		}
	}
	/**
	 * Mthode de parsing de flux XML avec validation  partir d'une grammaire DTD.
	 */
	public void testParsingWithValidationFromDTD() {
		ParserSaxXml parser = new ParserSaxXml();
		try {
			parser.parsingwithValidationFromDTD(file2Parse);
			assertTrue("Parsing sans Validation russie", true);
		} catch (SaxParsingException e) {
			e.printStackTrace();
			throw new AssertionError();
		}
	}
	/**
	 * Mthode de parsing de flux XML avec validation  partir d'une grammaire XSL-Schma avec prise en compte des espaces de nom.
	 */
	public void testParsingWithValidationFromXmlSchema() {
		ParserSaxXml parser = new ParserSaxXml();
		try {
			parser.parsingwithValidationFromXmlSchema(file2Parse);
			assertTrue("Parsing sans Validation russie", true);
		} catch (SaxParsingException e) {
			e.printStackTrace();
			throw new AssertionError();
		}
	}
}
