/*
 * Cr le 28 dc. 2003
 *
 * Codes Open Source pour Le Cahier du Programmeur Java[3] : 
 *		Java & XML: Le mariage de deux technologies complmentaires et autonomes
 * 
 * Auteur : R.Fleury (renaud.fleury@free.fr)
 */
package com.automne.octopuss.junit.xml.parsing.config;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;

import junit.framework.TestCase;

import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

import com.automne.octopuss.xml.parsing.config.IOctopussConfig;
import com.automne.octopuss.xml.parsing.config.OctopussConfigFactory;

/**
 * Projet  : Octopuss
 * Classe  : TestConfigParsing
 * Version : 1.0
 * But     : Tester le parsing du fichier de configuration via le Digester d'Apache.
 * 
 */
public class TestConfigParsing extends TestCase {

	private static Logger logger = Logger.getLogger(TestConfigParsing.class);

	/**
	 * 
	 */
	public TestConfigParsing() {
		super();
	}

	/**
	 * @param arg0
	 */
	public TestConfigParsing(String arg0) {
		super(arg0);
		BasicConfigurator.configure();
		
	}
	
	public void testDigester(){
		OctopussConfigFactory factory = new OctopussConfigFactory();
		try {
			IOctopussConfig config = factory.getConfig();
			assertNotNull("Succs du chargement de la configuration d'Octopuss: ",config);
			System.out.println("Impression des noms de Sources de Donnes charges:");
			Map dataSources = config.getDataSourcesConfig();
			Iterator it = dataSources.entrySet().iterator();
			while (it.hasNext()){
				System.out.println(it.next());
			}
		} catch (IOException e) {
			assertNotNull("Echec du chargement de la configuration d'Octopuss:",null);
			e.printStackTrace();
		} catch (SAXException e) {
			assertNotNull("Echec du chargement de la configuration d'Octopuss:",null);
			e.printStackTrace();
		}
	}

}
