/*
 * Cr le 9 nov. 2003
 *
 * Codes Open Source pour Le Cahier du Programmeur Java[3] : 
 *		Java & XML: Le mariage de deux technologies complmentaires et autonomes
 * 
 * Auteur : R.Fleury (renaud.fleury@free.fr)
 */
package com.automne.octopuss.log4j.test;

import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

/**
 * Projet  : Octopuss
 * Classe  : TestLog4j 
 * Version : 1.0
 * But     : Tester la fonctionnalit de log par l'API Log4J 
 * 			 tlchargeable <a href="http://jakarta.apache.org/log4j/">ici</a>
 * 
 */
public class TestLog4j {

	/**
	 * Constantes dfinissant le chemin d'accs au fichier de configuration de log4j.
	 */
	private static final String LOG4J_PROPERTIES_FILE_NAME = "conf/log4j.properties";
	/**
	 * Logger de la classe TestLog4j : Best Practices: 1 logger dfini pour chaque classe
	 */
	private static Logger logger = Logger.getLogger(TestLog4j.class);
	
	/**
	 * Mthode main: point d'entre du test  
	 * @param args
	 */
	public static void main(String[] args){
		//Appel au configurateur de proprits bien dfinies.
		PropertyConfigurator.configure(LOG4J_PROPERTIES_FILE_NAME);
		logger.info("Dbut de la mthode main");		
		try{
			float a=5;
			float b=1;
			logger.debug("Appel  la mthode division");
			float c = division(a,b);
			System.out.println(a+"/"+b+"->"+c);
		}catch(DivisionByZeroException e){
			logger.fatal("Exception rencontre: "+e);
		}
	}
	/**
	 * Mthode de division de a/b
	 * @param a
	 * @param b
	 * @return le rsultat de la division de a/b
	 * @throws ArithmeticException
	 */	
	private static float division(float a,float b) throws DivisionByZeroException{
		if (b==0){
			logger.warn("division par 0 impossible :"+a+"/"+b+" lvera une DivisionByZeroException...");
			throw new DivisionByZeroException("le dnominateur pass  la mthode Division vaut 0, l'exception DivisionByZeroException est leve...");
		}
		return a/b;		
	}
	/**
	 * 
	 * Projet  : Octopuss
	 * Classe  : prive DivisionByZeroException
	 * Version : 1.0 
	 * But     : Classe d'exception propre  notre test, donc classe prive par dduction d'architecture.
	 *
	 */
	private static class DivisionByZeroException extends Exception{
		/**
		 * Constructeur par dfaut
		 */
		public DivisionByZeroException(){
			super();
		}
		/**
		 * Constructeur avec message
		 * @param msg
		 */
		public DivisionByZeroException(String msg){
			super(msg);
		}
	}//Fin de la classe d'Exception	
}
