/*
 * Cr le 9 nov. 2003
 *
 * Codes Open Source pour Le Cahier du Programmeur Java[3] : 
 *		Java & XML: Le mariage de deux technologies complmentaires et autonomes
 * 
 * Auteur : R.Fleury (renaud.fleury@free.fr)
 */
package com.automne.octopuss.utils;

import java.io.IOException;
import java.io.InputStream;

import org.apache.log4j.Logger;

public class InputStreamFactory {
	private static Logger logger = Logger.getLogger(InputStreamFactory.class);
		private static InputStreamFactory instance = new InputStreamFactory();

	private InputStreamFactory() {
	}

	public static InputStreamProvider findProvider(String filename) {
		return instance.findProv(filename);
	}
	
	private InputStreamProvider findProv(String fileName) {
		
		InputStreamProvider localFileProvider = new LocalFileProvider(fileName);
		InputStreamProvider j2eeFileProvider = new J2EEFileProvider(fileName);
		InputStream localFile = null;
		InputStream j2eeFile = null;
		try {
			localFile = localFileProvider.getInputStream();
		} catch (IOException e) {
			logger.debug("unable to read file from local filesystem : " + fileName);
		}
		try {
			j2eeFile = j2eeFileProvider.getInputStream();
		} catch (IOException e1) {
			logger.debug("unable to read file from j2ee filesystem : " + fileName);
		}
		if(j2eeFile==null && localFile==null) {
			logger.error("Impossible d'ouvrir le fichier ni en local ni via J2EE : " + fileName);
			return localFileProvider;
		}
		if(j2eeFile!=null) {
			return j2eeFileProvider;
		}
		if(localFile!=null) {
			return localFileProvider;
		}
		return null;
	}
}
