/*
 * Cr le 9 nov. 2003
 *
 * Codes Open Source pour Le Cahier du Programmeur Java[3] : 
 *		Java & XML: Le mariage de deux technologies complmentaires et autonomes
 * 
 * Auteur : R.Fleury (renaud.fleury@free.fr)
 */
package com.automne.octopuss.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;

import org.apache.log4j.Logger;


class J2EEFileProvider implements InputStreamProvider {

	private static Logger logger = Logger.getLogger(J2EEFileProvider.class);
	
	private String fileName= null;
	
	public J2EEFileProvider(String file){
		fileName=file;
	}
	
	public synchronized InputStream getInputStream() throws IOException {
		logger.debug("stream to open is "+fileName);
		ClassLoader cl = getClass().getClassLoader();
		InputStream stream = cl.getResourceAsStream(fileName);
		logger.debug("trying to open J2EE stream "+cl.getResource(fileName));
		return stream;
	}
	
	public File getFile() {
		logger.debug("file to obtain is "+fileName);
		ClassLoader cl = getClass().getClassLoader();
		logger.debug("trying to open J2EE file "+cl.getResource(fileName));
		return new File(cl.getResource(fileName).getFile());
	}

}
