/*
 * Cr le 18 juillet 2004
 * 
 * Codes Open Source pour Le Cahier du Programmeur Java[3] : 
 *		Java & XML: Le mariage de deux technologies complmentaires et autonomes
 * 
 * Auteur : R.Fleury (renaud.fleury@free.fr)
 */
package com.automne.octopuss.xml.db;

import java.io.File;
import java.io.IOException;

import org.exist.dom.XMLUtil;
import org.exist.util.XMLFilenameFilter;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Database;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.CollectionManagementService;
import org.xmldb.api.modules.XMLResource;

/**
 * Projet  : Octopuss
 * Classe  : ExistDBManager
 * Version : 1.0
 * But     : Classe de Service de management d'accs  une base de donnes XML natives : Exist
 * 
 */
public class ExistDBManager {

	private String uriDb;
	private String login;
	private String pwd;
	/**
	 * Constructeur d'initialisation du Manager
	 * @throws ClassNotFoundException
	 * @throws IllegalAccessException
	 * @throws InstantiationException
	 * @throws XMLDBException
	 */
	public ExistDBManager(String configurationPath,String host,String port,String log,String pw) throws ClassNotFoundException, InstantiationException, IllegalAccessException, XMLDBException{
		super();	
		//Initialisation de l'uri
		uriDb = "xmldb:exist://"+host+":"+port+"/";
		//Initialisation du driver
		String driver ="org.exist.xmldb.DatabaseImpl";
		Class cl = Class.forName(driver);
		Database db = (Database)cl.newInstance();
		db.setProperty("configuration",configurationPath);
		DatabaseManager.registerDatabase(db);
		this.login=log;
		this.pwd=pw;
	}
	
	/**
	 * Mthode permettant de rcuprer le noeud root de la base de donnes 
	 * @throws XMLDBException
	 */
	public Collection getRootCollection() throws XMLDBException{
		return DatabaseManager.getCollection(uriDb+"/db",login,pwd);
	}
	/**
	 * Mthode de cration de collections par rapport  une uri d'un pre. 
	 * @return Aucun!
	 * @throws ClassNotFoundException
	 * @throws IllegalAccessException
	 * @throws InstantiationException
	 * @throws XMLDBException
	 */
	public void createCollection(String parentCollection,String collectionName) throws ClassNotFoundException, InstantiationException, IllegalAccessException, XMLDBException{
		Collection root = DatabaseManager.getCollection(uriDb+parentCollection,login,pwd);		
		CollectionManagementService service =
			(CollectionManagementService) root.getService(
				"CollectionManagementService",
				"1.0");
		service.createCollection(collectionName);	
	}
	/**
	 * Mthode de stockage de flux XML (fichiers) pour une collection donne! 
	 * @return XMLResource : la ressource XML stocke sous la collection  partir d'un flux Fichier
	 * @throws XMLDBException
	 * @throws IOException
	*/
	public XMLResource storeDataInCollection(File xmlFile,String uriCollection) throws XMLDBException, IOException{
		Collection collection = DatabaseManager.getCollection(uriDb+uriCollection,login,pwd);		
		XMLResource res;
		String xml;
		res =
			(XMLResource) collection.createResource(
					xmlFile.getName(),
				"XMLResource");
		xml = XMLUtil.readFile(xmlFile, "UTF-8");
		res.setContent(xml);
		collection.storeResource(res);
		return res;
	}
	/**
	 * Mthode de stockage de flux XML (Ressources XML) pour une collection donne! 
	 * @return XMLResource : la ressource XML stocke sous la collection  partir d'un flux Fichier
	 * @throws XMLDBException
	 * @throws IOException
	*/
	public XMLResource storeDataInCollection(XMLResource xmlFile,String uriCollection) throws XMLDBException, IOException{
		Collection collection = DatabaseManager.getCollection(uriDb+uriCollection,login,pwd);		
		collection.storeResource(xmlFile);
	
		return (XMLResource)xmlFile;
	}
	/**
	 * Mthode de stockage de flux XML se trouvant dans un rpertoire donn pour une collection donne! 
	 * @return XMLResource : les ressources XML stockes sous la collection  partir d'un rpertoire
	 * @throws XMLDBException
	 * @throws IOException
	*/
	public XMLResource[] storeDataDirectoryInCollection(File xmlDirectory,String uriCollection) throws XMLDBException, IOException{
		XMLResource[] res=null;
		File files[] = xmlDirectory.listFiles(new XMLFilenameFilter());
		res=new XMLResource[files.length];
		for (int i = 0; i < files.length; i++) {
			res[i] = storeDataInCollection(files[i], uriCollection);
		}
		return res;
	}
	/**
	 * Mthode de suppression d'une collection 
	 * @return Aucun!
	 * @throws XMLDBException
	 * @throws IOException
	*/
	public void removeCollection(String uriCollection) throws XMLDBException{
		Collection root = DatabaseManager.getCollection(uriDb+uriCollection,login,pwd);		
				CollectionManagementService service =
			(CollectionManagementService) root.getService(
				"CollectionManagementService",
				"1.0");
		service.removeCollection(root.getName());
	}
	
	public Collection getCollection(String uriCollection) throws XMLDBException{
		return DatabaseManager.getCollection(uriDb+uriCollection,login,pwd);	
	}
	/**
	 * Mthode de suppression d'une ressource dans une collection 
	 * @return Aucun!
	 * @throws XMLDBException
	*/
	public void removeRessource(XMLResource res,String uriCollection) throws XMLDBException{
		Collection collection = DatabaseManager.getCollection(uriDb+uriCollection,login,pwd);
		collection.removeResource(res);
	}
	/**
	 * Mthode de suppression d'une ressource dans une collection 
	 * @return Aucun!
	 * @throws XMLDBException
	*/
	public void removeRessource(String resourceXMLId,String uriCollection) throws XMLDBException{
		Collection collection = DatabaseManager.getCollection(uriDb+uriCollection,login,pwd);		
		collection.removeResource(collection.getResource(resourceXMLId));
	}
}
