/*
 * Cr le 14 dc. 2003
 *
 * Codes Open Source pour Le Cahier du Programmeur Java[3] : 
 *		Java & XML: Le mariage de deux technologies complmentaires et autonomes
 * 
 * Auteur : R.Fleury (renaud.fleury@free.fr)
 */
package com.automne.octopuss.xml.impl;

import java.io.OutputStream;

import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

import com.automne.octopuss.xml.IXmlService;

/**
 * Projet  : Octopuss
 * Classe  : 
 * Version : 
 * But     :
 * 
 */
public class XMLServiceFactory implements IXmlService {

	/**
	 * Constructeur par dfaut
	 */
	public XMLServiceFactory() {
		super();
	}

	/**
	 * Mthode de transformation de flux XML en HTML. Utilisation de Templates pour gain en performance.
	 * @see com.automne.octopuss.xml.IXmlService#transformXml2Html(java.lang.String, java.lang.String, java.io.OutputStream)
	 */
	public void transformXml2Html(
		String xmlFile,
		String xslFile,
		OutputStream out) throws TransformerException {
			//Instanciation d'une fabrique de transformation de flux XML
			TransformerFactory factory = TransformerFactory.newInstance();
			//Obtention d'un template matrialisant la transformation du flux par rapport  une fiche de style
			Templates templateTransformation = factory.newTemplates(new StreamSource(xslFile));
			//Rcupration d'un objet permettant la transformation par rapport au template compil
			Transformer transformer = templateTransformation.newTransformer();
			//Transformation  proprement dit
			transformer.transform(new StreamSource(xmlFile),new StreamResult(out));
	}

}
