/*
 * Cr le 30 nov. 2003
 *
 * Codes Open Source pour Le Cahier du Programmeur Java[3] : 
 *		Java & XML: Le mariage de deux technologies complmentaires et autonomes
 * 
 * Auteur : R.Fleury (renaud.fleury@free.fr)
 */
package com.automne.octopuss.xml.parsing;

import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;

/**
 * Projet  : Octopuss
 * Classe  : ParserDomXml
 * Version : 1.0 
 * But     : Permettre de parser un fichier XML par la mthode DOM.
 * 
 */
public class ParserDomXml implements ErrorHandler {

	/**
	 * Nom du parseur  utiliser.
	 */	
	private DOMParser parser = null;
	/**
	 * Constructeur par dfaut 
	 */
	public ParserDomXml() {		
	  parser = new DOMParser();
	  parser.setErrorHandler(this);
  } // <init>()

  //
  // ParserWrapper methods
  //

  /** Parses the specified URI and returns the document. */
  public Document parse(String uri) throws Exception {
	  parser.parse(uri);
	  return parser.getDocument();
  } // parse(String):Document

  /** Sets a feature. */
  public void setFeature(String featureId, boolean state)
	  throws SAXNotRecognizedException, SAXNotSupportedException {
	  parser.setFeature(featureId, state);
  } // setFeature(String,boolean)

  


  /** Warning. */
  public void warning(SAXParseException ex) throws SAXException {
	  System.err.println("[Warning]"+ex);
  }

  /** Error. */
  public void error(SAXParseException ex) throws SAXException {
	System.err.println("[Error]"+ex);
  }

  /** Fatal error. */
  public void fatalError(SAXParseException ex) throws SAXException {
	System.err.println("[Fatal Error]"+ex);
	  
  }

	 /** Traverses the specified node, recursively. */
    public void count(Node node) {

        // is there anything to do?
        if (node == null) {
            return;
        }

        int type = node.getNodeType();
        switch (type) {
            case Node.DOCUMENT_NODE: {
                Document document = (Document)node;
                System.out.println("Dbut de documents");
                count(document.getDocumentElement());
                break;
            }

            case Node.ELEMENT_NODE: {
                System.out.println("Elment :"+node.getNodeName());
                NamedNodeMap attrs = node.getAttributes();
                if (attrs != null) {
                	for(int i=0;i<attrs.getLength();i++){
                		System.out.println("---->Attribut ("+attrs.item(i).getLocalName()+") a pour valeur" +attrs.item(i));
                	}
                }
				System.out.print("---->Valeur de l'lment :");
                // drop through to entity reference
            }

            case Node.ENTITY_REFERENCE_NODE: {
                Node child = node.getFirstChild();             	
                while (child != null) {
                    count(child);
                    child = child.getNextSibling();
                }
                break;
            }

            case Node.CDATA_SECTION_NODE: {
                break;
            }

            case Node.TEXT_NODE: {
            	System.out.println(node.getNodeValue());
                break;
            }
        }

    } // count(Node)

	
}
