/*
 * Cr le 30 nov. 2003
 *
 * Codes Open Source pour Le Cahier du Programmeur Java[3] : 
 *		Java & XML: Le mariage de deux technologies complmentaires et autonomes
 * 
 * Auteur : R.Fleury (renaud.fleury@free.fr)
 */
package com.automne.octopuss.xml.parsing;

import java.io.IOException;

import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

/**
 * Projet  : Octopuss
 * Classe  : ParserSaxXml
 * Version : 1.0
 * But     : Permettre de parser un fichier XML par la mthode SAX.
 * 
 */
public class ParserSaxXml extends DefaultHandler {

	/**
	 * Nom du parseur  utiliser.
	 */
	private String nameParser = null;
	
	/**
	 * Parser utilis pour la mthode SAX
	 */
	private XMLReader parser = null;
	
	private Logger logger = Logger.getLogger(ParserSaxXml.class); 
	
	/**
	 * Constructeur par dfaut qui permet de spcifier le parser de Xerces comme
	 * nom de parseur.
	 */
	public ParserSaxXml(){
		nameParser="org.apache.xerces.parsers.SAXParser";
	}
	/**
	 * Constructeur avec un argument
	 * @param name: Nom de la classe implmentant le parser!
	 */
	public ParserSaxXml(String name){
			nameParser=name;
	}
	/**
	 * Mthode permettant de rcuprer un parseur!
	 * @return
	 * @throws SaxParsingException
	 */
	public XMLReader getXMLReader() throws SaxParsingException{	
		 // create parser
		 	XMLReader parser=null;
			try {
				parser = XMLReaderFactory.createXMLReader(nameParser);
			} catch (SAXException e) {
				logger.error(e);
				throw new SaxParsingException(e);
			}
			return parser;
	}
	/**
	 * Mthode prive permettant d'initialiser le parser utilis.
	 * @throws SaxParsingException
	 */
	private void setUpParsing() throws SaxParsingException{
		this.parser= getXMLReader();
		parser.setContentHandler(this);
		parser.setErrorHandler(this);
		
	}
	/**
	 * Mthode de parsing via SAX.
	 * @param uriFile
	 * @throws SaxParsingException
	 */
	private void parse(String uriFile) throws SaxParsingException{
		try {
			 long timeBefore = System.currentTimeMillis();
			 long memoryBefore = Runtime.getRuntime().freeMemory();
			 parser.parse(uriFile);
			 long memoryAfter = Runtime.getRuntime().freeMemory();
			 long timeAfter = System.currentTimeMillis();
			 long time = timeAfter - timeBefore;
			 long memory = memoryBefore - memoryAfter;
			 System.out.println("-----");
			 System.out.println("Aprs parsing:");
			 System.out.println("      ---> Mmoire utilise (octets): "+memory/8);
			 System.out.println("      ---> Temps mis (en ms): "+time);
			}
			catch (SAXParseException e) {
				logger.error(e);
				throw new SaxParsingException(e);
			}catch (IOException e) {
				logger.error(e);
				throw new SaxParsingException(e);
			}catch (SAXException e) {
				logger.error(e);
				throw new SaxParsingException(e);
			}
	}
	/**
	 * Mthode de parsing SAX sans validation.
	 * @param uriFile
	 * @throws SaxParsingException
	 */
	public void parsingwithoutValidation(String uriFile)throws SaxParsingException{
		setUpParsing();
		try {
			parser.setFeature("http://xml.org/sax/features/validation",false);
		} catch (SAXNotRecognizedException e) {
			logger.error(e);
			throw new SaxParsingException(e);
		} catch (SAXNotSupportedException e) {
			logger.error(e);
			throw new SaxParsingException(e);
		}		
		parse(uriFile);
	}

	/**
	 * Mthode surcharge hrit de DefaultHandler permettant de grer des erreurs.
	 * @see org.xml.sax.helpers.DefaultHandler 
	 */
	public void error(SAXParseException ex) throws SAXException {
		System.err.println("[Error] : "+ex);
	} // error(SAXParseException)

	/**
	 * Mthode de parsing SAX avec validation  partir d'une DTD.
	 * @param uriFile
	 * @throws SaxParsingException
	 */
	public void parsingwithValidationFromDTD(String uriFile)throws SaxParsingException{
		setUpParsing();
		try {
			parser.setFeature("http://xml.org/sax/features/validation",true);
		} catch (SAXNotRecognizedException e) {
			logger.error(e);
			throw new SaxParsingException(e);
		} catch (SAXNotSupportedException e) {
			logger.error(e);
			throw new SaxParsingException(e);
		}
		parse(uriFile);
	} 
	/**
	 * Mthode de parsing SAX avec validation  partir d'un Schma Xml en prenant en compte les espaces de nommage. 
	 * @param uriFile
	 * @throws SaxParsingException
	 */
	public void parsingwithValidationFromXmlSchema(String uriFile)throws SaxParsingException{
		setUpParsing();
		try {
			parser.setFeature("http://xml.org/sax/features/validation",true);
			parser.setFeature("http://apache.org/xml/features/validation/schema",true);
			parser.setFeature("http://apache.org/xml/features/validation/schema-full-checking",true);
		} catch (SAXNotRecognizedException e) {
			logger.error(e);
			throw new SaxParsingException(e);
		} catch (SAXNotSupportedException e) {
			logger.error(e);
			throw new SaxParsingException(e);
		}
		parse(uriFile);
	}
	/**
	* Mthode surcharge hrit de DefaultHandler permettant de grer le dbut d'une balise.
	* @see org.xml.sax.helpers.DefaultHandler 
	*/
	public void startElement(java.lang.String uri,
						 java.lang.String localName,
						 java.lang.String qName,
						 Attributes attributes)
				  throws SAXException{
				  System.out.println("-----");
				  System.out.println("Nom de la balise: "+localName);
 				  int indexFin = attributes.getLength();	
				  if (indexFin==0){		     
 				  	System.out.println("     -----> Attribut(s) de la balise: Aucun");
				  }else{
				   System.out.println("     -----> Attribut(s) de la balise: ");
				   for(int i=0;i<indexFin;i++){
					  System.out.println("              ------> Nom: "+attributes.getLocalName(i));
				  	  System.out.println("              ------> Valeur: "+attributes.getValue(i));
				   }
				  }
				  System.out.print("     -----> Valeur de la balise: ");
	}
	/**
	 * Mthode surcharge hrit de DefaultHandler permettant de grer le contenu d'une balise.
	 * @see org.xml.sax.helpers.DefaultHandler 
	 */
	public void characters(char[] ch,
                       int start,
                       int length)
                throws SAXException{
				String content = new String(ch,start,length);
				System.out.println(content);
	}
	/**
	 * Mthode surcharge hrit de DefaultHandler permettant d'intercepter l'vnement de dbut d'un document  parser 
	 * @see org.xml.sax.helpers.DefaultHandler 
	 */
	public void startDocument()throws SAXException{
				  System.out.println("-----");
				  System.out.println("Dbut du parsing...");
				  System.out.println("-----");
	}				  
	/**
	 * Mthode surcharge hrit de DefaultHandler permettant d'intercepter l'vnement de fin d'un document  parser
	 * @see org.xml.sax.helpers.DefaultHandler 
	 */
	public void endDocument()throws SAXException{
				  System.out.println("-----");
				  System.out.println("Fin du parsing...");
				  System.out.println("-----");
	}				  
				  
}
