/*
 * Cr le 28 dc. 2003
 *
 * Codes Open Source pour Le Cahier du Programmeur Java[3] : 
 *		Java & XML: Le mariage de deux technologies complmentaires et autonomes
 * 
 * Auteur : R.Fleury (renaud.fleury@free.fr)
 */
package com.automne.octopuss.xml.parsing.config;

import java.io.IOException;
import java.io.InputStream;

import org.apache.commons.digester.Digester;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.SimpleLog;
import org.xml.sax.SAXException;

import com.automne.octopuss.utils.InputStreamFactory;
import com.automne.octopuss.xml.parsing.config.impl.OctopussConfigImpl;
import com.automne.octopuss.xml.parsing.config.impl.OctopussConfigRulesSet;

/**
 * Projet  : Octopuss
 * Classe  : OctopussConfigFactory
 * Version : 1.0
 * But     : Chargement de la configuration de base du projet Octopuss
 * 
 */
public class OctopussConfigFactory {

	
	private InputStream xmlStream = null;
	/**
	 * 
	 */
	public OctopussConfigFactory() {
		super();
		try {
			xmlStream = InputStreamFactory.findProvider("conf/octopuss-config.xml").getInputStream();
		} catch (IOException e) {			
			e.printStackTrace();
		}
	}
	
	public IOctopussConfig getConfig() throws IOException, SAXException{
		OctopussConfigImpl returned = new OctopussConfigImpl();
		Digester digester = new Digester();
		digester.push(returned);
		Log log = new SimpleLog("Test");
		digester.setLogger(log);
		digester.setValidating(false);
		OctopussConfigRulesSet rules = new OctopussConfigRulesSet();
		rules.addRuleInstances(digester);
		if (xmlStream!=null){
			digester.parse(xmlStream);
		}else{
			returned = null;
		}
		return returned;
	}

}
