/*
 * Decompiled with CFR 0.152.
 */
package com.cappuccinonet.strutscx.util;

import com.cappuccinonet.strutscx.exceptions.StrutsCXException;
import com.cappuccinonet.strutscx.util.StrutsCXStringUtils;
import com.cappuccinonet.strutscx.util.StrutsCXXMLReader;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.output.XMLOutputter;

public class StrutsCXHelper {
    private String THIS_CLASS = "[StrutsCXHelper] ";
    private static Logger logger = Logger.getLogger((String)"com.cappuccinonet.strutscx");
    private String dateToday;
    private String thisYear;

    public void setBasicDomainParameters(HttpServletRequest request, HttpSession session, ServletConfig config, Document properties) throws StrutsCXException {
        String domainparam_flag = (String)config.getServletContext().getAttribute("com.cappuccinonet.strutscx.domainparams_flag");
        JXPathContext props = JXPathContext.newContext((Object)properties);
        if (domainparam_flag != null && domainparam_flag.compareTo("true") == 0) {
            logger.debug((Object)(String.valueOf(this.THIS_CLASS) + "-------------------------------------------- RECYCLE DOMAINPARAMS IN CONTEXT"));
        } else {
            logger.debug((Object)(String.valueOf(this.THIS_CLASS) + "-------------------------------------------- DOMAINPARAMS IN CONTEXT"));
            String domain = request.getServerName();
            config.getServletContext().setAttribute("domain", (Object)domain);
            String httpDomain = "http://" + request.getServerName() + ":" + new Integer(request.getServerPort()).toString();
            config.getServletContext().setAttribute("httpDomain", (Object)httpDomain);
            String port = new Integer(request.getServerPort()).toString();
            config.getServletContext().setAttribute("port", (Object)port);
            String rootpath = config.getServletContext().getRealPath("/");
            config.getServletContext().setAttribute("rootpath", (Object)rootpath);
            String projectName = (String)props.getValue("/properties/param/project");
            logger.debug((Object)(String.valueOf(this.THIS_CLASS) + "/param/project is " + projectName));
            if (projectName == null || projectName.compareTo("") == 0) {
                throw new StrutsCXException("Please set the param/project parameter in the strutscx-config.xml");
            }
            config.getServletContext().setAttribute("projectName", (Object)projectName);
            try {
                this.loadResourcePropertiesFiles(config, properties);
            }
            catch (ServletException se) {
                logger.error((Object)(String.valueOf(this.THIS_CLASS) + "ServletException"));
                se.printStackTrace();
            }
            config.getServletContext().setAttribute("com.cappuccinonet.strutscx.domainparams_flag", (Object)"TRUE");
        }
        String sessionDomainparam_flag = (String)session.getAttribute("com.cappuccinonet.strutscx.domainparams_flag");
        if (sessionDomainparam_flag != null && sessionDomainparam_flag.compareTo("true") == 0) {
            logger.debug((Object)(String.valueOf(this.THIS_CLASS) + "-------------------------------------------- RECYCLE DOMAINPARAMS IN SESSION"));
        } else {
            logger.debug((Object)(String.valueOf(this.THIS_CLASS) + "-------------------------------------------- DOMAINPARAMS IN SESSION"));
            session.setAttribute("domain", config.getServletContext().getAttribute("domain"));
            logger.debug((Object)(String.valueOf(this.THIS_CLASS) + "domain: " + config.getServletContext().getAttribute("domain")));
            session.setAttribute("httpDomain", config.getServletContext().getAttribute("httpDomain"));
            logger.debug((Object)(String.valueOf(this.THIS_CLASS) + "httpDomain: " + config.getServletContext().getAttribute("httpDomain")));
            session.setAttribute("port", config.getServletContext().getAttribute("port"));
            logger.debug((Object)(String.valueOf(this.THIS_CLASS) + "port: " + config.getServletContext().getAttribute("port")));
            session.setAttribute("rootpath", config.getServletContext().getAttribute("rootpath"));
            logger.debug((Object)(String.valueOf(this.THIS_CLASS) + "rootpath: " + config.getServletContext().getAttribute("rootpath")));
            session.setAttribute("projectName", config.getServletContext().getAttribute("projectName"));
            logger.debug((Object)(String.valueOf(this.THIS_CLASS) + "projectName: " + config.getServletContext().getAttribute("projectName")));
            session.setAttribute("com.cappuccinonet.strutscx.domainparams_flag", (Object)"TRUE");
            String version = (String)props.getValue("/properties/version");
            session.setAttribute("version", (Object)version);
            logger.debug((Object)(String.valueOf(this.THIS_CLASS) + "set version parameter " + version));
        }
        logger.debug((Object)(String.valueOf(this.THIS_CLASS) + "-------------------------------------------- "));
    }

    public int getEntryId(HttpServletRequest request) {
        String _entryId = request.getParameter("entryId");
        logger.debug((Object)(String.valueOf(this.THIS_CLASS) + "entryId parameter is " + _entryId));
        int entryId = _entryId == null || _entryId.trim().equals("") ? 1 : Integer.parseInt(_entryId);
        logger.debug((Object)(String.valueOf(this.THIS_CLASS) + "got this entryId: " + _entryId));
        request.setAttribute("entryId", (Object)Integer.toString(entryId));
        logger.debug((Object)(String.valueOf(this.THIS_CLASS) + "Set the following entryId: " + entryId));
        return entryId;
    }

    private String getDateToday(HttpSession session, Locale locale) {
        this.dateToday = (String)session.getAttribute("dateToday");
        if (this.dateToday != null) {
            logger.debug((Object)(String.valueOf(this.THIS_CLASS) + "recycle servers date: " + this.dateToday));
        } else {
            this.dateToday = new StrutsCXStringUtils().getDateString(locale.getLanguage());
            session.setAttribute("dateToday", (Object)this.dateToday);
            logger.debug((Object)(String.valueOf(this.THIS_CLASS) + "DATE_TODAY : " + this.dateToday));
        }
        return this.dateToday;
    }

    public void setDateStrings(HttpSession session, Locale locale) {
        this.dateToday = this.getDateToday(session, locale);
        this.thisYear = this.getYear(session);
    }

    private String getYear(HttpSession session) {
        this.thisYear = (String)session.getAttribute("thisYear");
        if (this.thisYear != null) {
            logger.debug((Object)(String.valueOf(this.THIS_CLASS) + "recycle servers date: " + this.thisYear));
        } else {
            this.thisYear = new StrutsCXStringUtils().getThisYearString();
            session.setAttribute("thisYear", (Object)this.thisYear);
            logger.debug((Object)(String.valueOf(this.THIS_CLASS) + "THIS_YEAR : " + this.thisYear));
        }
        return this.thisYear;
    }

    public Locale getLocale(HttpServletRequest request, HttpSession session) {
        String sessionCountry;
        String sessionLocale = (String)session.getAttribute("locale");
        if (sessionLocale == null) {
            sessionLocale = "en";
        }
        if ((sessionCountry = (String)session.getAttribute("country")) == null) {
            sessionCountry = "US";
        }
        logger.debug((Object)(String.valueOf(this.THIS_CLASS) + "SESSIONLOCALE IS: " + sessionLocale + " SESSIONCOUNTRY IS: " + sessionCountry));
        String requestLocale = request.getParameter("locale");
        logger.debug((Object)(String.valueOf(this.THIS_CLASS) + "REQUESTLOCALE IS: " + requestLocale));
        String requestCountry = request.getParameter("country");
        logger.debug((Object)(String.valueOf(this.THIS_CLASS) + "REQUESTLOCALE IS: " + requestCountry));
        if (requestLocale != null) {
            sessionLocale = requestLocale;
        }
        if (requestCountry != null) {
            sessionCountry = requestCountry;
        }
        Locale myLocale = new Locale(sessionLocale, sessionCountry);
        session.setAttribute("locale", (Object)sessionLocale);
        logger.debug((Object)(String.valueOf(this.THIS_CLASS) + "LOCALE IS SET TO: " + sessionLocale));
        session.setAttribute("country", (Object)sessionCountry);
        logger.debug((Object)(String.valueOf(this.THIS_CLASS) + "COUNTRY IS SET TO: " + sessionCountry));
        return myLocale;
    }

    public String getEncoding(HttpServletRequest request, Document properties, Locale locale) throws StrutsCXException {
        String encoding = request.getParameter("encoding_key");
        if (encoding == null || encoding.compareTo("") == 0) {
            JXPathContext props = JXPathContext.newContext((Object)properties);
            encoding = (String)props.getValue("/properties/encoding/" + locale.getLanguage());
        }
        if (encoding == null || encoding.trim().compareTo("") == 0) {
            throw new StrutsCXException(String.valueOf(this.THIS_CLASS) + "Please provide a encoding value in the strutscx-config.xml " + "for the following locale: " + locale);
        }
        request.setAttribute("encoding_key", (Object)encoding);
        logger.debug((Object)(String.valueOf(this.THIS_CLASS) + "SET ENCODING TO: " + encoding));
        return encoding;
    }

    public String getPersisttype(HttpServletRequest request, Document properties) {
        String persisttype = request.getParameter("persisttype");
        if (persisttype == null || persisttype.compareTo("") == 0) {
            JXPathContext props = JXPathContext.newContext((Object)properties);
            persisttype = (String)props.getValue("/properties/param/persist");
        }
        request.setAttribute("persisttype", (Object)persisttype);
        logger.debug((Object)(String.valueOf(this.THIS_CLASS) + "SET PERSIST_KEY TO: " + persisttype));
        return persisttype;
    }

    public String getViewtype(HttpServletRequest request, Document properties) {
        String viewtype = request.getParameter("viewtype");
        if (viewtype == null || viewtype.compareTo("") == 0) {
            JXPathContext props = JXPathContext.newContext((Object)properties);
            viewtype = (String)props.getValue("/properties/param/view");
        }
        request.setAttribute("viewtype", (Object)viewtype);
        logger.debug((Object)(String.valueOf(this.THIS_CLASS) + "SET VIEW_KEY TO: " + viewtype));
        return viewtype;
    }

    private void loadResourcePropertiesFiles(ServletConfig config, Document properties) throws ServletException {
        JXPathContext props = JXPathContext.newContext((Object)properties);
        String lang = (String)props.getValue("/properties/lang");
        StringTokenizer tokenizer = new StringTokenizer(lang);
        while (tokenizer.hasMoreElements()) {
            String locale = tokenizer.nextToken();
            Locale locale_ = new Locale(locale);
            logger.debug((Object)(String.valueOf(this.THIS_CLASS) + "tokenized locale is: " + locale));
            String encoding = (String)props.getValue("/properties/encoding/" + locale);
            logger.debug((Object)(String.valueOf(this.THIS_CLASS) + "encoding for locale is: " + encoding));
            Document doc = new Document();
            String variablesFile = (String)props.getValue("/properties/variables/" + locale);
            doc = new StrutsCXXMLReader(config, variablesFile).getDocument();
            String variablesFileName = "com.cappuccinonet.strutscx.ressourceproperties_files." + locale.trim();
            config.getServletContext().setAttribute(variablesFileName, (Object)doc);
            XMLOutputter outputter = new XMLOutputter("  ", true);
            logger.debug((Object)(String.valueOf(this.THIS_CLASS) + "variables parameter name set to: " + variablesFileName));
        }
    }
}

