/*
 * Decompiled with CFR 0.152.
 */
package com.cappuccinonet.strutscx.util;

import com.cappuccinonet.strutscx.util.StrutsCXFOPInitializer;
import com.cappuccinonet.strutscx.util.StrutsCXXMLReader;
import java.util.StringTokenizer;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.JXPathException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.action.PlugIn;
import org.apache.struts.config.ModuleConfig;
import org.jdom.Document;

public class StrutsCXPlugIn
implements PlugIn {
    protected Log logger = LogFactory.getLog(this.getClass());
    private String config;
    private String version = "v0.9.5";

    public void init(ActionServlet servlet, ModuleConfig moduleConfig) throws ServletException {
        String file = this.getConfig();
        Document properties = new StrutsCXXMLReader((ServletConfig)servlet, this.getConfig()).getDocument();
        servlet.getServletContext().setAttribute("com.cappuccinonet.strutscx.properties", (Object)properties);
        JXPathContext props = JXPathContext.newContext((Object)properties);
        servlet.getServletContext().setAttribute("strutscx_version", (Object)this.version);
        this.loadResourcePropertiesFiles((ServletConfig)servlet, properties);
        String fop_on_ = (String)props.getValue("/properties/fop/on");
        if (fop_on_.compareTo("ON") == 0) {
            servlet.getServletContext().setAttribute("enable_fop", (Object)"TRUE");
            StrutsCXFOPInitializer fop = new StrutsCXFOPInitializer((ServletConfig)servlet, fop_on_);
        } else {
            servlet.getServletContext().setAttribute("enable_fop", (Object)"FALSE");
        }
        String debugxml_on_ = (String)props.getValue("/properties/debugxml/on");
        if (debugxml_on_.compareTo("ON") == 0) {
            servlet.getServletContext().setAttribute("enable_debugxml", (Object)"TRUE");
            this.logger.info((Object)"DEBUGXML is switched ON!");
        } else {
            this.logger.info((Object)"DEBUGXML is switched OFF. Use of debugxml=true NOT possible!");
            servlet.getServletContext().setAttribute("enable_debugxml", (Object)"FALSE");
        }
        if (((String)servlet.getServletContext().getAttribute("enable_fop")).compareTo("TRUE") == 0) {
            this.logger.info((Object)"FOP is switched ON!");
            String fop_config = (String)props.getValue("/properties/fop/config");
            StrutsCXFOPInitializer fop_init = new StrutsCXFOPInitializer((ServletConfig)servlet, fop_config);
        } else {
            this.logger.info((Object)"FOP is switched OFF. Go to use StrutsCX without FOP!");
        }
        this.logger.info((Object)"----------------------------- STRUTSCX APPLICATION STARTED");
        this.logger.info((Object)"successfully set the strutscx-config.xml to the ServletContext");
        this.logger.info((Object)("StrutsCX " + this.version + " initialized!"));
    }

    public void destroy() {
        this.logger.info((Object)("StrutsCX " + this.version + " cleaned up!"));
    }

    public String getConfig() {
        return this.config;
    }

    public void setConfig(String string) {
        this.config = string;
    }

    public void loadResourcePropertiesFiles(ServletConfig servlet, Document properties) throws ServletException {
        JXPathContext props = JXPathContext.newContext((Object)properties);
        String on = null;
        try {
            on = (String)props.getValue("/properties/resources-properties/on");
        }
        catch (JXPathException e) {
            this.logger.info((Object)"/properties/resources-properties/on is not set in strutscx-config.xml");
        }
        if (on == null || on.compareTo("ON") == 0) {
            this.logger.info((Object)"RESOURCE-PROPERTIES is switched ON! They will be available in ServletContext.");
            String lang = (String)props.getValue("/properties/lang");
            StringTokenizer tokenizer = new StringTokenizer(lang);
            while (tokenizer.hasMoreElements()) {
                String language = tokenizer.nextToken().trim();
                this.logger.debug((Object)("tokenized locale is: " + language));
                String encoding = (String)props.getValue("/properties/encoding/" + language);
                this.logger.debug((Object)("encoding for locale is: " + encoding));
                Document doc = new Document();
                String variablesFile = null;
                try {
                    variablesFile = (String)props.getValue("/properties/resources-properties/" + language);
                }
                catch (JXPathException e) {
                    this.logger.info((Object)"/properties/resources-properties is not set in strutscx-config.xml");
                }
                if (variablesFile == null) {
                    variablesFile = (String)props.getValue("/properties/variables/" + language);
                }
                if ((doc = new StrutsCXXMLReader(servlet, variablesFile).getDocument()) != null) {
                    String variablesFileName = "com.cappuccinonet.strutscx.ressourceproperties_files." + language.trim();
                    this.logger.debug((Object)("resource properties parameter set to: " + variablesFileName));
                    servlet.getServletContext().setAttribute(variablesFileName, (Object)doc);
                    continue;
                }
                this.logger.warn((Object)"Could not find resource properties!");
            }
        } else {
            this.logger.info((Object)"RESOURCE-PROPERTIES are switched OFF! They won't be available.");
        }
    }
}

