/*
 * Decompiled with CFR 0.152.
 */
package com.cappuccinonet.strutscx.xslt;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Element;
import org.jdom.Text;

public class StrutsCXBeanToElement {
    protected Log logger = LogFactory.getLog(this.getClass());

    public Element getBeanContent(Object bean) {
        this.logger.debug((Object)"------------------------------------------- SERIALIZE BEAN");
        Element root = null;
        try {
            root = this.checkBeanContent(bean);
        }
        catch (IntrospectionException ie) {
            this.logger.error((Object)"IntrospectionException");
            ie.printStackTrace();
        }
        catch (IllegalAccessException iae) {
            this.logger.error((Object)"IllegalAccessException");
            iae.printStackTrace();
        }
        catch (InvocationTargetException ite) {
            this.logger.error((Object)"InvocationTargetException");
            ite.printStackTrace();
        }
        catch (Exception e) {
            this.logger.error((Object)"Exception");
            e.printStackTrace();
        }
        return root;
    }

    private Element checkBeanContent(Object bean) throws IntrospectionException, IllegalAccessException, InvocationTargetException {
        BeanInfo info = Introspector.getBeanInfo(bean.getClass());
        PropertyDescriptor[] properties = info.getPropertyDescriptors();
        Element root = new Element(info.getBeanDescriptor().getName());
        int i = 0;
        while (i < properties.length) {
            Class<?> type = properties[i].getPropertyType();
            String name = properties[i].getName();
            Method m = properties[i].getReadMethod();
            if (m != null) {
                Object value = m.invoke(bean, null);
                if (value == null) {
                    value = new String("");
                }
                root = this.getBeanElement(name, value, root);
            }
            ++i;
        }
        return root;
    }

    public Element getBeanElement(String name, Object value, Element baseElement) {
        try {
            if (value != null) {
                Class<?> _class = value.getClass();
                Package _package = _class.getPackage();
                if (value instanceof Collection | _class.isArray()) {
                    List<Object> collection = null;
                    collection = _class.isArray() ? Arrays.asList((Object[])value) : (List<Object>)value;
                    Element list = new Element(name);
                    Iterator i = collection.iterator();
                    while (i.hasNext()) {
                        list = this.getBeanElement("item", i.next(), list);
                    }
                    baseElement.addContent(list);
                } else if (_package != null && _package.getName().equals("java.lang")) {
                    Element e = new Element(name);
                    e.addContent(new Text(value.toString()));
                    baseElement.addContent(e);
                } else if (value instanceof java.util.Date | value instanceof Date | value instanceof Timestamp | value instanceof Time) {
                    Element class_name = this.getDateTree((java.util.Date)value, name);
                    baseElement.addContent(class_name);
                } else if (_package != null) {
                    Element e = this.checkBeanContent(value);
                    baseElement.addContent(e);
                }
            }
        }
        catch (NullPointerException e) {
            this.logger.debug((Object)"NullPointerException");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return baseElement;
    }

    public Element getDateTree(java.util.Date value, String element_name) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(value);
        Element class_name = new Element(element_name);
        Element string = new Element("string");
        string.addContent(new Text(value.toString()));
        class_name.addContent(string);
        Element era = new Element("era");
        era.addContent(new Text("" + calendar.get(0)));
        class_name.addContent(era);
        Element year = new Element("year");
        year.addContent(new Text("" + calendar.get(1)));
        class_name.addContent(year);
        Element month = new Element("month");
        if (value instanceof java.util.Date) {
            month.addContent(new Text("" + (calendar.get(2) + 1)));
        } else {
            month.addContent(new Text("" + calendar.get(2)));
        }
        class_name.addContent(month);
        Element week_of_year = new Element("week_of_year");
        era.addContent(new Text("" + calendar.get(3)));
        class_name.addContent(week_of_year);
        Element week_of_month = new Element("week_of_month");
        week_of_month.addContent(new Text("" + calendar.get(4)));
        class_name.addContent(week_of_month);
        Element date = new Element("date");
        date.addContent(new Text("" + calendar.get(5)));
        class_name.addContent(date);
        Element day_of_month = new Element("day_of_month");
        day_of_month.addContent(new Text("" + calendar.get(5)));
        class_name.addContent(day_of_month);
        Element day_of_year = new Element("day_of_year");
        day_of_year.addContent(new Text("" + calendar.get(6)));
        class_name.addContent(day_of_year);
        Element day_of_week = new Element("day_of_week");
        day_of_week.addContent(new Text("" + calendar.get(7)));
        class_name.addContent(day_of_week);
        Element day_of_week_in_month = new Element("day_of_week_in_month");
        day_of_week_in_month.addContent(new Text("" + calendar.get(8)));
        class_name.addContent(day_of_week_in_month);
        Element am_pm = new Element("am_pm");
        am_pm.addContent(new Text("" + calendar.get(9)));
        class_name.addContent(am_pm);
        Element hour = new Element("hour");
        hour.addContent(new Text("" + calendar.get(10)));
        class_name.addContent(hour);
        Element hour_of_day = new Element("hour_of_day");
        hour_of_day.addContent(new Text("" + calendar.get(11)));
        class_name.addContent(hour_of_day);
        Element minute = new Element("minute");
        minute.addContent(new Text("" + calendar.get(12)));
        class_name.addContent(minute);
        Element second = new Element("second");
        second.addContent(new Text("" + calendar.get(13)));
        class_name.addContent(second);
        Element millisecond = new Element("millisecond");
        millisecond.addContent(new Text("" + calendar.get(14)));
        class_name.addContent(millisecond);
        Element zone_offset = new Element("zone_offset");
        zone_offset.addContent(new Text("" + calendar.get(15) / 3600000));
        class_name.addContent(zone_offset);
        Element dst_offset = new Element("dst_offset");
        dst_offset.addContent(new Text("" + calendar.get(16) / 3600000));
        return class_name.addContent(dst_offset);
    }
}

